/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStateCarrier
extends ForgeEntity {
    protected static final String CARRIED_STATE_TAG = "carried_state";
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK_STATE = EntityDataManager.func_187226_a(BlockStateCarrier.class, (IDataSerializer)DataSerializers.field_187197_g);

    public BlockStateCarrier(EntityType<?> type, World world, BlockPos pos, BlockState carriedState) {
        super(type, world);
        Vect3d centeredPos = BlockStateCarrier.getCenteredPosTo(pos);
        this.setAllPositions(centeredPos);
        this.setCarriedBlockState(Optional.ofNullable(carriedState));
    }

    public BlockStateCarrier(EntityType<?> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CARRIED_BLOCK_STATE, Optional.empty());
    }

    public Optional<BlockState> getCarriedBlockState() {
        return (Optional)this.func_184212_Q().func_187225_a(CARRIED_BLOCK_STATE);
    }

    protected void setCarriedBlockState(Optional<BlockState> newState) {
        this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, newState);
    }

    public boolean carriesSameBlock(Optional<? extends Block> block) {
        return this.getCarriedBlockState().map(state -> state.func_177230_c()).equals(block);
    }

    public Optional<ResourceLocation> getTextureLocation() {
        BlockState state = this.getCarriedBlockState().orElse(null);
        if (state != null && state.func_177230_c() instanceof ForgeBlock) {
            ForgeBlock block = (ForgeBlock)state.func_177230_c();
            ResourceLocation location = block.getTextureLocationFor(state);
            return Optional.of(location);
        }
        return Optional.empty();
    }

    protected void func_213281_b(CompoundNBT compound) {
        this.getCarriedBlockState().ifPresent(state -> compound.func_218657_a(CARRIED_STATE_TAG, (INBT)NBTUtil.func_190009_a((BlockState)state)));
    }

    protected void func_70037_a(CompoundNBT compound) {
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l(CARRIED_STATE_TAG));
        this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, Optional.of(state));
    }
}

