/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.entity;

import com.jozufozu.flywheel.backend.instancing.IInstance;
import com.jozufozu.flywheel.backend.material.InstanceMaterial;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.materials.OrientedData;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public abstract class EntityInstance<E extends Entity>
implements IInstance {
    protected final MaterialManager<?> materialManager;
    protected final E entity;
    protected final World world;

    public EntityInstance(MaterialManager<?> materialManager, E entity) {
        this.materialManager = materialManager;
        this.entity = entity;
        this.world = ((Entity)entity).field_70170_p;
    }

    @Override
    public abstract void remove();

    @Override
    public void update() {
    }

    @Override
    public void updateLight() {
    }

    @Override
    public boolean shouldReset() {
        return false;
    }

    public Vector3f getInstancePosition() {
        Vector3d pos = this.entity.func_213303_ch();
        Vector3i origin = this.materialManager.getOriginCoordinate();
        return new Vector3f((float)(pos.field_72450_a - (double)origin.func_177958_n()), (float)(pos.field_72448_b - (double)origin.func_177956_o()), (float)(pos.field_72449_c - (double)origin.func_177952_p()));
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.entity.func_233580_cy_();
    }

    protected void relight(BlockPos pos, IFlatLight<?> ... models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected <L extends IFlatLight<?>> void relight(BlockPos pos, Stream<L> models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected void relight(int block, int sky, IFlatLight<?> ... models) {
        this.relight(block, sky, Arrays.stream(models));
    }

    protected <L extends IFlatLight<?>> void relight(int block, int sky, Stream<L> models) {
        models.forEach(model -> ((IFlatLight)model.setBlockLight(block)).setSkyLight(sky));
    }

    protected InstanceMaterial<ModelData> getTransformMaterial() {
        return this.materialManager.defaultSolid().material(Materials.TRANSFORMED);
    }

    protected InstanceMaterial<OrientedData> getOrientedMaterial() {
        return this.materialManager.defaultSolid().material(Materials.ORIENTED);
    }
}

