/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.FluxCapabilities;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ISuperAdmin;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.common.capability.SuperAdmin;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.storage.FluxChunkManager;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class NetworkHandler {
    private static final ResourceLocation NAME = new ResourceLocation("fluxnetworks", "main_network");
    private static final String PROTOCOL = "620";

    public static void register() {
        EventNetworkChannel network = NetworkRegistry.newEventChannel((ResourceLocation)NAME, () -> PROTOCOL, PROTOCOL::equals, PROTOCOL::equals);
        if (FMLEnvironment.dist.isClient()) {
            network.addListener(NetworkHandler::onClientCustomPayload);
        }
        network.addListener(NetworkHandler::onServerCustomPayload);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onClientCustomPayload(@Nonnull NetworkEvent.ServerCustomPayloadEvent event) {
        if (event.getLoginIndex() == Integer.MIN_VALUE) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                C.handle(event.getPayload().readShort(), event.getPayload(), player);
            }
            event.getPayload().release();
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private static void onServerCustomPayload(@Nonnull NetworkEvent.ClientCustomPayloadEvent event) {
        ServerPlayerEntity player;
        if (event.getLoginIndex() == Integer.MIN_VALUE && (player = ((NetworkEvent.Context)event.getSource().get()).getSender()) != null) {
            NetworkHandler.handle(event.getPayload().readShort(), event.getPayload(), player);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    @Nonnull
    public static PacketBuffer S2C_TileEntity(@Nonnull TileFluxDevice tile, byte type) {
        PacketBuffer buf = NetworkHandler.buffer(0);
        buf.func_179255_a(tile.func_174877_v());
        buf.writeByte((int)type);
        tile.writePacket(buf, type);
        return buf;
    }

    private static void S2C_Response(@Nonnull FeedbackInfo code, @Nonnull ServerPlayerEntity player) {
        PacketBuffer buf = NetworkHandler.buffer(1);
        buf.func_150787_b(code.ordinal());
        NetworkHandler.sendToPlayer(buf, player);
    }

    public static void S2C_SuperAdmin(boolean state, PlayerEntity player) {
        PacketBuffer buf = NetworkHandler.buffer(2);
        buf.writeBoolean(state);
        NetworkHandler.sendToPlayer(buf, player);
    }

    @Nonnull
    public static PacketBuffer S2C_UpdateNetwork(@Nonnull IFluxNetwork network, int type) {
        PacketBuffer buf = NetworkHandler.buffer(3);
        buf.func_150787_b(type);
        buf.func_150787_b(1);
        buf.func_150787_b(network.getNetworkID());
        CompoundNBT tag = new CompoundNBT();
        network.writeCustomNBT(tag, type);
        buf.func_150786_a(tag);
        return buf;
    }

    @Nonnull
    public static PacketBuffer S2C_UpdateNetwork(@Nonnull Collection<IFluxNetwork> networks, int type) {
        PacketBuffer buf = NetworkHandler.buffer(3);
        buf.func_150787_b(type);
        buf.func_150787_b(networks.size());
        for (IFluxNetwork network : networks) {
            buf.func_150787_b(network.getNetworkID());
            CompoundNBT tag = new CompoundNBT();
            network.writeCustomNBT(tag, type);
            buf.func_150786_a(tag);
        }
        return buf;
    }

    private static void S2C_UpdateAccess(@Nonnull AccessLevel level, ServerPlayerEntity player) {
        PacketBuffer buf = NetworkHandler.buffer(4);
        buf.func_150787_b(level.ordinal());
        NetworkHandler.sendToPlayer(buf, player);
    }

    private static void S2C_UpdateConnection(int networkID, @Nonnull List<CompoundNBT> tags, ServerPlayerEntity player) {
        PacketBuffer buf = NetworkHandler.buffer(5);
        buf.func_150787_b(networkID);
        buf.func_150787_b(tags.size());
        tags.forEach(arg_0 -> ((PacketBuffer)buf).func_150786_a(arg_0));
        NetworkHandler.sendToPlayer(buf, player);
    }

    private static void handle(short index, @Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        switch (index) {
            case 0: {
                NetworkHandler.tileEntity(buf, player);
                break;
            }
            case 1: {
                NetworkHandler.responseSuperAdmin(buf, player);
                break;
            }
            case 2: {
                NetworkHandler.editMember(buf, player);
                break;
            }
            case 3: {
                NetworkHandler.editNetwork(buf, player);
                break;
            }
            case 4: {
                NetworkHandler.editWireless(buf, player);
                break;
            }
            case 5: {
                NetworkHandler.responseNetworkUpdate(buf, player);
                break;
            }
            case 6: {
                NetworkHandler.setNetwork(buf, player);
                break;
            }
            case 7: {
                NetworkHandler.createNetwork(buf, player);
                break;
            }
            case 8: {
                NetworkHandler.deleteNetwork(buf, player);
                break;
            }
            case 9: {
                NetworkHandler.responseAccessUpdate(buf, player);
                break;
            }
            case 10: {
                NetworkHandler.editConnections(buf, player);
                break;
            }
            case 11: {
                NetworkHandler.responseConnectionUpdate(buf, player);
                break;
            }
            case 12: {
                NetworkHandler.configuratorNet(buf, player);
                break;
            }
            case 13: {
                NetworkHandler.configuratorEdit(buf, player);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void tileEntity(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
        if (tile instanceof TileFluxDevice) {
            TileFluxDevice flux = (TileFluxDevice)tile;
            if (!flux.canPlayerAccess((PlayerEntity)player)) {
                return;
            }
            byte type = buf.readByte();
            flux.readPacket(buf, type);
            if (type == 6 && !FluxConfig.enableChunkLoading) {
                NetworkHandler.S2C_Response(FeedbackInfo.BANNED_LOADING, player);
            }
        }
    }

    private static void responseSuperAdmin(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        ISuperAdmin sa = (ISuperAdmin)FluxUtils.get(player.getCapability(FluxCapabilities.SUPER_ADMIN));
        if (sa != null && (sa.hasPermission() || SuperAdmin.canActivateSuperAdmin((PlayerEntity)player))) {
            sa.changePermission();
            if (sa.hasPermission()) {
                NetworkHandler.S2C_Response(FeedbackInfo.SA_ON, player);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.SA_OFF, player);
            }
            NetworkHandler.S2C_SuperAdmin(sa.hasPermission(), (PlayerEntity)player);
        }
    }

    private static void editMember(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity sender) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        AccessLevel senderAccess = network.getPlayerAccess((PlayerEntity)sender);
        if (!senderAccess.canEdit()) {
            NetworkHandler.S2C_Response(FeedbackInfo.NO_ADMIN, sender);
            return;
        }
        UUID targetUUID = buf.func_179253_g();
        int type = buf.func_150792_a();
        boolean self = PlayerEntity.func_146094_a((GameProfile)sender.func_146103_bH()).equals(targetUUID);
        Optional<NetworkMember> current = network.getMemberByUUID(targetUUID);
        if (type == 1) {
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(targetUUID);
            if (target != null && !current.isPresent()) {
                NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.USER);
                network.getRawMemberMap().put((Object)m.getPlayerUUID(), (Object)m);
                NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, sender);
                NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 22), sender);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.INVALID_USER, sender);
            }
        } else if (current.isPresent()) {
            NetworkMember c = current.get();
            if (self || c.getAccessLevel() == AccessLevel.OWNER) {
                return;
            }
            if (type == 2) {
                if (!senderAccess.canDelete()) {
                    NetworkHandler.S2C_Response(FeedbackInfo.NO_OWNER, sender);
                    return;
                }
                c.setAccessLevel(AccessLevel.ADMIN);
            } else if (type == 3) {
                c.setAccessLevel(AccessLevel.USER);
            } else if (type == 4) {
                network.getRawMemberMap().remove((Object)targetUUID);
            } else if (type == 5) {
                if (!senderAccess.canDelete()) {
                    NetworkHandler.S2C_Response(FeedbackInfo.NO_OWNER, sender);
                    return;
                }
                network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                network.setOwnerUUID(targetUUID);
                c.setAccessLevel(AccessLevel.OWNER);
            }
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, sender);
            NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 22), sender);
        } else if (type == 5) {
            if (!senderAccess.canDelete()) {
                NetworkHandler.S2C_Response(FeedbackInfo.NO_OWNER, sender);
                return;
            }
            if (self && senderAccess == AccessLevel.OWNER) {
                return;
            }
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(targetUUID);
            if (target != null) {
                network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.OWNER);
                network.getRawMemberMap().put((Object)m.getPlayerUUID(), (Object)m);
                network.setOwnerUUID(targetUUID);
                NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, sender);
                NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 22), sender);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.INVALID_USER, sender);
            }
        } else {
            NetworkHandler.S2C_Response(FeedbackInfo.INVALID_USER, sender);
        }
    }

    private static void editNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        String name = buf.func_150789_c(256);
        int color = buf.readInt();
        SecurityType security = SecurityType.values()[buf.func_150792_a()];
        String password = buf.func_150789_c(256);
        if (network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            if (!network.getNetworkName().equals(name)) {
                network.setNetworkName(name);
            }
            if (network.getNetworkColor() != color) {
                network.setNetworkColor(color);
                network.getConnections(FluxLogicType.ANY).forEach(device -> {
                    if (device instanceof TileFluxDevice) {
                        ((TileFluxDevice)device).sendFullUpdatePacket();
                    }
                });
            }
            if (FluxUtils.isLegalPassword(password)) {
                network.getSecurity().set(security, password);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.ILLEGAL_PASSWORD, player);
            }
            NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 21), player);
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS_2, player);
        } else {
            NetworkHandler.S2C_Response(FeedbackInfo.NO_ADMIN, player);
        }
    }

    private static void editWireless(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        if (network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            network.setWirelessMode(buf.func_150792_a());
            NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 21), player);
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
        } else {
            NetworkHandler.S2C_Response(FeedbackInfo.NO_ADMIN, player);
        }
    }

    private static void responseNetworkUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int type = buf.func_150792_a();
        int size = buf.func_150792_a();
        ArrayList<IFluxNetwork> networks = new ArrayList<IFluxNetwork>();
        for (int i = 0; i < size; ++i) {
            IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
            if (!network.isValid()) continue;
            networks.add(network);
        }
        if (!networks.isEmpty()) {
            NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(networks, type), player);
        }
    }

    private static void setNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
        if (!(tile instanceof TileFluxDevice)) {
            return;
        }
        TileFluxDevice flux = (TileFluxDevice)tile;
        int networkID = buf.func_150792_a();
        if (flux.getNetworkID() == networkID) {
            return;
        }
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (network.isValid() && flux.getDeviceType().isController() && !network.getConnections(FluxLogicType.CONTROLLER).isEmpty()) {
            NetworkHandler.S2C_Response(FeedbackInfo.HAS_CONTROLLER, player);
        } else {
            if (network.isValid() && NetworkHandler.noAccess(buf.func_150789_c(256), player, network)) {
                return;
            }
            if (network.isValid()) {
                flux.setConnectionOwner(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
            }
            flux.connect(network);
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
        }
    }

    private static boolean noAccess(String password, ServerPlayerEntity player, @Nonnull IFluxNetwork network) {
        if (!network.getPlayerAccess((PlayerEntity)player).canUse()) {
            if (network.getSecurity().getType() == SecurityType.PRIVATE) {
                NetworkHandler.S2C_Response(FeedbackInfo.REJECT, player);
                return true;
            }
            if (password.isEmpty()) {
                NetworkHandler.S2C_Response(FeedbackInfo.PASSWORD_REQUIRE, player);
                return true;
            }
            if (!password.equals(network.getSecurity().getPassword())) {
                NetworkHandler.S2C_Response(FeedbackInfo.REJECT, player);
                return true;
            }
        }
        return false;
    }

    private static void createNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        String name = buf.func_150789_c(256);
        int color = buf.readInt();
        SecurityType security = SecurityType.values()[buf.func_150792_a()];
        String password = buf.func_150789_c(256);
        if (FluxUtils.isLegalPassword(password)) {
            if (FluxNetworkData.get().createNetwork((PlayerEntity)player, name, color, security, password) != null) {
                NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.NO_SPACE, player);
            }
        } else {
            NetworkHandler.S2C_Response(FeedbackInfo.ILLEGAL_PASSWORD, player);
        }
    }

    private static void deleteNetwork(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (network.isValid()) {
            if (network.getPlayerAccess((PlayerEntity)player).canDelete()) {
                FluxNetworkData.get().deleteNetwork(network);
                NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
            } else {
                NetworkHandler.S2C_Response(FeedbackInfo.NO_OWNER, player);
            }
        }
    }

    private static void responseAccessUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        AccessLevel access = network.getPlayerAccess((PlayerEntity)player);
        NetworkHandler.S2C_UpdateAccess(access, player);
    }

    private static void editConnections(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        IFluxNetwork network = FluxNetworkData.getNetwork(buf.func_150792_a());
        if (!network.isValid()) {
            return;
        }
        if (!network.getPlayerAccess((PlayerEntity)player).canEdit()) {
            NetworkHandler.S2C_Response(FeedbackInfo.NO_ADMIN, player);
            return;
        }
        int flags = buf.func_150792_a();
        int size = buf.func_150792_a();
        if (size == 0) {
            return;
        }
        ArrayList toEdit = new ArrayList();
        for (int i = 0; i < size; ++i) {
            network.getConnectionByPos(FluxUtils.readGlobalPos(buf)).ifPresent(toEdit::add);
        }
        if (toEdit.isEmpty()) {
            return;
        }
        if ((flags & 0x40) != 0) {
            toEdit.forEach(IFluxDevice::disconnect);
            NetworkHandler.sendToPlayer(NetworkHandler.S2C_UpdateNetwork(network, 23), player);
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS_2, player);
        } else {
            boolean editName = (flags & 1) != 0;
            boolean editPriority = (flags & 2) != 0;
            boolean editLimit = (flags & 4) != 0;
            boolean editSurgeMode = (flags & 8) != 0;
            boolean editDisableLimit = (flags & 0x10) != 0;
            boolean editChunkLoading = (flags & 0x20) != 0;
            String name = null;
            int priority = 0;
            long limit = 0L;
            boolean surgeMode = false;
            boolean disableLimit = false;
            boolean chunkLoading = false;
            if (editName) {
                name = buf.func_150789_c(256);
            }
            if (editPriority) {
                priority = buf.readInt();
            }
            if (editLimit) {
                limit = buf.readLong();
            }
            if (editSurgeMode) {
                surgeMode = buf.readBoolean();
            }
            if (editDisableLimit) {
                disableLimit = buf.readBoolean();
            }
            if (editChunkLoading) {
                chunkLoading = buf.readBoolean();
            }
            boolean sendBannedLoading = false;
            for (IFluxDevice d : toEdit) {
                if (!(d instanceof TileFluxDevice)) continue;
                TileFluxDevice t = (TileFluxDevice)d;
                if (editName) {
                    t.setCustomName(name);
                }
                if (editPriority) {
                    t.setPriority(priority);
                }
                if (editLimit) {
                    t.setTransferLimit(limit);
                }
                if (editSurgeMode) {
                    t.setSurgeMode(surgeMode);
                }
                if (editDisableLimit) {
                    t.setDisableLimit(disableLimit);
                }
                if (editChunkLoading && !t.getDeviceType().isStorage()) {
                    if (FluxConfig.enableChunkLoading) {
                        if (chunkLoading && !t.isForcedLoading()) {
                            FluxChunkManager.addChunkLoader(t);
                        } else if (!chunkLoading && t.isForcedLoading()) {
                            FluxChunkManager.removeChunkLoader(t);
                        }
                        t.setForcedLoading(FluxChunkManager.isChunkLoader(t));
                    } else {
                        t.setForcedLoading(false);
                        sendBannedLoading = true;
                    }
                }
                t.sendFullUpdatePacket();
            }
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
            if (sendBannedLoading) {
                NetworkHandler.S2C_Response(FeedbackInfo.BANNED_LOADING, player);
            }
        }
    }

    private static void responseConnectionUpdate(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int networkID = buf.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        int size = buf.func_150792_a();
        ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
        for (int i = 0; i < size; ++i) {
            GlobalPos pos = FluxUtils.readGlobalPos(buf);
            network.getConnectionByPos(pos).ifPresent(c -> {
                CompoundNBT tag = new CompoundNBT();
                c.writeCustomNBT(tag, 20);
                tags.add(tag);
            });
        }
        if (!tags.isEmpty()) {
            NetworkHandler.S2C_UpdateConnection(networkID, tags, player);
        }
    }

    private static void configuratorNet(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        int networkID = buf.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (network.isValid()) {
            if (NetworkHandler.noAccess(buf.func_150789_c(256), player, network)) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() == RegistryItems.FLUX_CONFIGURATOR) {
                CompoundNBT configs = stack.func_190925_c("FluxConfig");
                configs.func_74768_a("networkID", networkID);
            }
            NetworkHandler.S2C_Response(FeedbackInfo.SUCCESS, player);
        }
    }

    private static void configuratorEdit(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        String customName = buf.func_150789_c(256);
        CompoundNBT tag = buf.func_150793_b();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == RegistryItems.FLUX_CONFIGURATOR) {
            if (tag != null && !tag.isEmpty()) {
                stack.func_77983_a("FluxConfig", (INBT)tag);
            }
            stack.func_200302_a((ITextComponent)new StringTextComponent(customName));
        }
    }

    @Nonnull
    private static PacketBuffer buffer(int index) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeShort(index);
        return buffer;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendToServer(@Nonnull PacketBuffer buf) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147297_a((IPacket)new CCustomPayloadPacket(NAME, buf));
        } else {
            buf.release();
        }
    }

    public static void sendToPlayer(@Nonnull PacketBuffer buf, @Nonnull PlayerEntity player) {
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToPlayer(@Nonnull PacketBuffer buf, @Nonnull ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToPlayers(@Nonnull PacketBuffer buf, @Nonnull Iterable<? extends PlayerEntity> players) {
        SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NAME, buf);
        for (PlayerEntity playerEntity : players) {
            ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    public static void sendToAll(@Nonnull PacketBuffer buf) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148540_a((IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToDimension(@Nonnull PacketBuffer buf, @Nonnull RegistryKey<World> dimension) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232642_a_((IPacket)new SCustomPayloadPlayPacket(NAME, buf), dimension);
    }

    public static void sendToNearby(@Nonnull PacketBuffer buf, @Nullable PlayerEntity excluded, double x, double y, double z, double radius, @Nonnull RegistryKey<World> dimension) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148543_a(excluded, x, y, z, radius, dimension, (IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToTrackingEntity(@Nonnull PacketBuffer buf, @Nonnull Entity entity) {
        ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b(entity, (IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToTrackingAndSelf(@Nonnull PacketBuffer buf, @Nonnull Entity entity) {
        ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a(entity, (IPacket)new SCustomPayloadPlayPacket(NAME, buf));
    }

    public static void sendToTrackingChunk(@Nonnull PacketBuffer buf, @Nonnull Chunk chunk) {
        SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NAME, buf);
        ((ServerWorld)chunk.func_177412_p()).func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(arg_0 -> NetworkHandler.lambda$sendToTrackingChunk$5((IPacket)packet, arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_TileEntity(@Nonnull TileFluxDevice tile, byte type) {
        PacketBuffer buf = NetworkHandler.buffer(0);
        buf.func_179255_a(tile.func_174877_v());
        buf.writeByte((int)type);
        tile.writePacket(buf, type);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_RequestSuperAdmin() {
        PacketBuffer buf = NetworkHandler.buffer(1);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_EditMember(int networkID, UUID playerChanged, int type) {
        PacketBuffer buf = NetworkHandler.buffer(2);
        buf.func_150787_b(networkID);
        buf.func_179252_a(playerChanged);
        buf.func_150787_b(type);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_EditNetwork(int networkID, String name, int color, @Nonnull SecurityType security, String password) {
        PacketBuffer buf = NetworkHandler.buffer(3);
        buf.func_150787_b(networkID);
        buf.func_211400_a(name, 256);
        buf.writeInt(color);
        buf.func_150787_b(security.ordinal());
        buf.func_211400_a(password, 256);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_EditWireless(int networkID, int mode) {
        PacketBuffer buf = NetworkHandler.buffer(4);
        buf.func_150787_b(networkID);
        buf.func_150787_b(mode);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_RequestNetworkUpdate(@Nonnull IFluxNetwork network, int type) {
        PacketBuffer buf = NetworkHandler.buffer(5);
        buf.func_150787_b(type);
        buf.func_150787_b(1);
        buf.func_150787_b(network.getNetworkID());
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_RequestNetworkUpdate(@Nonnull Collection<IFluxNetwork> networks, int type) {
        PacketBuffer buf = NetworkHandler.buffer(5);
        buf.func_150787_b(type);
        buf.func_150787_b(networks.size());
        for (IFluxNetwork network : networks) {
            buf.func_150787_b(network.getNetworkID());
        }
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_SetNetwork(BlockPos pos, int networkID, String password) {
        PacketBuffer buf = NetworkHandler.buffer(6);
        buf.func_179255_a(pos);
        buf.func_150787_b(networkID);
        buf.func_211400_a(password, 256);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_CreateNetwork(String name, int color, @Nonnull SecurityType security, String password) {
        PacketBuffer buf = NetworkHandler.buffer(7);
        buf.func_211400_a(name, 256);
        buf.writeInt(color);
        buf.func_150787_b(security.ordinal());
        buf.func_211400_a(password, 256);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_DeleteNetwork(int networkID) {
        PacketBuffer buf = NetworkHandler.buffer(8);
        buf.func_150787_b(networkID);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_RequestAccessUpdate(int networkID) {
        PacketBuffer buf = NetworkHandler.buffer(9);
        buf.func_150787_b(networkID);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_Disconnect(int networkID, @Nonnull List<GlobalPos> list) {
        PacketBuffer buf = NetworkHandler.buffer(10);
        buf.func_150787_b(networkID);
        buf.func_150787_b(64);
        buf.func_150787_b(list.size());
        for (GlobalPos pos : list) {
            FluxUtils.writeGlobalPos(buf, pos);
        }
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_EditConnections(int networkID, @Nonnull List<GlobalPos> list, int flags, String name, int priority, long limit, boolean surgeMode, boolean disableLimit, boolean chunkLoading) {
        PacketBuffer buf = NetworkHandler.buffer(10);
        buf.func_150787_b(networkID);
        buf.func_150787_b(flags);
        buf.func_150787_b(list.size());
        for (GlobalPos pos : list) {
            FluxUtils.writeGlobalPos(buf, pos);
        }
        if ((flags & 1) != 0) {
            buf.func_211400_a(name, 256);
        }
        if ((flags & 2) != 0) {
            buf.writeInt(priority);
        }
        if ((flags & 4) != 0) {
            buf.writeLong(limit);
        }
        if ((flags & 8) != 0) {
            buf.writeBoolean(surgeMode);
        }
        if ((flags & 0x10) != 0) {
            buf.writeBoolean(disableLimit);
        }
        if ((flags & 0x20) != 0) {
            buf.writeBoolean(chunkLoading);
        }
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_RequestConnectionUpdate(int networkID, @Nonnull List<GlobalPos> list) {
        PacketBuffer buf = NetworkHandler.buffer(11);
        buf.func_150787_b(networkID);
        buf.func_150787_b(list.size());
        for (GlobalPos pos : list) {
            FluxUtils.writeGlobalPos(buf, pos);
        }
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_ConfiguratorNet(int id, String password) {
        PacketBuffer buf = NetworkHandler.buffer(12);
        buf.func_150787_b(id);
        buf.func_211400_a(password, 256);
        NetworkHandler.sendToServer(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void C2S_ConfiguratorEdit(String customName, CompoundNBT tag) {
        PacketBuffer buf = NetworkHandler.buffer(13);
        buf.func_211400_a(customName, 256);
        buf.func_150786_a(tag);
        NetworkHandler.sendToServer(buf);
    }

    private static /* synthetic */ void lambda$sendToTrackingChunk$5(IPacket packet, ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class C {
        private C() {
        }

        private static void handle(short index, @Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            switch (index) {
                case 0: {
                    C.tileEntity(buf, player);
                    break;
                }
                case 1: {
                    C.response(buf, player);
                    break;
                }
                case 2: {
                    C.updateSuperAdmin(buf, player);
                    break;
                }
                case 3: {
                    C.updateNetwork(buf, player);
                    break;
                }
                case 4: {
                    C.updateAccess(buf, player);
                    break;
                }
                case 5: {
                    C.updateConnection(buf, player);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static void tileEntity(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            TileEntity tile = player.field_70170_p.func_175625_s(buf.func_179259_c());
            if (tile instanceof TileFluxDevice) {
                ((TileFluxDevice)tile).readPacket(buf, buf.readByte());
            }
        }

        private static void response(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            FeedbackInfo info = FeedbackInfo.values()[buf.func_150792_a()];
            boolean action = info.action();
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (!action) {
                FluxClientCache.setFeedbackText(info);
            } else if (screen instanceof GuiFluxCore) {
                ((GuiFluxCore)screen).onFeedbackAction(info);
            }
        }

        private static void updateSuperAdmin(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            FluxClientCache.superAdmin = buf.readBoolean();
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFluxAdminHome) {
                ((GuiFluxAdminHome)screen).superAdmin.toggled = FluxClientCache.superAdmin;
            }
        }

        private static void updateNetwork(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            int type = buf.func_150792_a();
            Int2ObjectArrayMap updatedNetworks = new Int2ObjectArrayMap();
            int size = buf.func_150792_a();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                updatedNetworks.put(buf.func_150792_a(), (Object)buf.func_150793_b());
            }
            FluxClientCache.updateNetworks((Int2ObjectMap<CompoundNBT>)updatedNetworks, type);
        }

        private static void updateAccess(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            AccessLevel access = AccessLevel.values()[buf.func_150792_a()];
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFluxCore) {
                GuiFluxCore gui = (GuiFluxCore)screen;
                gui.accessLevel = access;
            }
        }

        private static void updateConnection(@Nonnull PacketBuffer buf, @Nonnull ClientPlayerEntity player) {
            int networkID = buf.func_150792_a();
            int size = buf.func_150792_a();
            ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
            for (int i = 0; i < size; ++i) {
                tags.add(buf.func_150793_b());
            }
            FluxClientCache.updateConnections(networkID, tags);
        }
    }
}

