/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sonar.fluxnetworks.api.energy.FNEnergyStorage;
import sonar.fluxnetworks.client.render.FluxStorageItemRenderer;
import sonar.fluxnetworks.common.block.FluxControllerBlock;
import sonar.fluxnetworks.common.block.FluxPlugBlock;
import sonar.fluxnetworks.common.block.FluxPointBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.capability.SuperAdmin;
import sonar.fluxnetworks.common.integration.TOPIntegration;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxDevice;
import sonar.fluxnetworks.common.item.ItemFluxDust;
import sonar.fluxnetworks.common.loot.FluxLootTableProvider;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.recipe.FluxStorageRecipeSerializer;
import sonar.fluxnetworks.common.recipe.NBTWipeRecipeSerializer;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.registry.RegistrySounds;
import sonar.fluxnetworks.common.tileentity.TileFluxController;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;
import sonar.fluxnetworks.common.tileentity.TileFluxPoint;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;
import sonar.fluxnetworks.register.NetworkHandler;

@Mod.EventBusSubscriber(modid="fluxnetworks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonRegistration {
    public static final ItemGroup ITEM_GROUP = new ItemGroup("fluxnetworks"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryItems.FLUX_CORE);
        }
    };

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
        SuperAdmin.register();
        FNEnergyStorage.register();
    }

    @SubscribeEvent
    public static void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("carryon")) {
            InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "fluxnetworks:*");
        }
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPIntegration::new);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        AbstractBlock.Properties normalProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.0f, 1000.0f);
        AbstractBlock.Properties deviceProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.0f, 1000.0f).func_226896_b_();
        registry.register((IForgeRegistryEntry)((Block)new Block(normalProps).setRegistryName("flux_block")));
        registry.register((IForgeRegistryEntry)((Block)new FluxPlugBlock(deviceProps).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((Block)new FluxPointBlock(deviceProps).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((Block)new FluxControllerBlock(deviceProps).setRegistryName("flux_controller")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Basic(deviceProps).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Herculean(deviceProps).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((Block)new FluxStorageBlock.Gargantuan(deviceProps).setRegistryName("gargantuan_flux_storage")));
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Item.Properties props = new Item.Properties().func_200916_a(ITEM_GROUP);
        registry.register((IForgeRegistryEntry)((Item)new BlockItem(RegistryBlocks.FLUX_BLOCK, props).setRegistryName("flux_block")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.FLUX_PLUG, props).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.FLUX_POINT, props).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.FLUX_CONTROLLER, props).setRegistryName("flux_controller")));
        Item.Properties storageProps = new Item.Properties().func_200916_a(ITEM_GROUP).setISTER(() -> FluxStorageItemRenderer::new);
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.BASIC_FLUX_STORAGE, storageProps).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.HERCULEAN_FLUX_STORAGE, storageProps).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDevice(RegistryBlocks.GARGANTUAN_FLUX_STORAGE, storageProps).setRegistryName("gargantuan_flux_storage")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxDust(props).setRegistryName("flux_dust")));
        registry.register((IForgeRegistryEntry)((Item)new Item(props).setRegistryName("flux_core")));
        registry.register((IForgeRegistryEntry)((Item)new ItemFluxConfigurator(props).setRegistryName("flux_configurator")));
        registry.register((IForgeRegistryEntry)((Item)new ItemAdminConfigurator(props).setRegistryName("admin_configurator")));
    }

    @SubscribeEvent
    public static void onTileEntityRegistry(@Nonnull RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxPlug::new, (Block[])new Block[]{RegistryBlocks.FLUX_PLUG}).func_206865_a(null).setRegistryName("flux_plug")));
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxPoint::new, (Block[])new Block[]{RegistryBlocks.FLUX_POINT}).func_206865_a(null).setRegistryName("flux_point")));
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxController::new, (Block[])new Block[]{RegistryBlocks.FLUX_CONTROLLER}).func_206865_a(null).setRegistryName("flux_controller")));
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxStorage.Basic::new, (Block[])new Block[]{RegistryBlocks.BASIC_FLUX_STORAGE}).func_206865_a(null).setRegistryName("basic_flux_storage")));
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxStorage.Herculean::new, (Block[])new Block[]{RegistryBlocks.HERCULEAN_FLUX_STORAGE}).func_206865_a(null).setRegistryName("herculean_flux_storage")));
        registry.register((IForgeRegistryEntry)((TileEntityType)TileEntityType.Builder.func_223042_a(TileFluxStorage.Gargantuan::new, (Block[])new Block[]{RegistryBlocks.GARGANTUAN_FLUX_STORAGE}).func_206865_a(null).setRegistryName("gargantuan_flux_storage")));
    }

    @SubscribeEvent
    public static void onContainerRegistry(@Nonnull RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((ContainerType)IForgeContainerType.create((windowId, inventory, buffer) -> {
            if (buffer.readBoolean()) {
                BlockPos pos = buffer.func_179259_c();
                TileEntity tile = inventory.field_70458_d.func_130014_f_().func_175625_s(pos);
                if (tile instanceof TileFluxDevice) {
                    return new FluxMenu(windowId, inventory, (TileFluxDevice)tile);
                }
            } else {
                ItemStack stack = inventory.field_70458_d.func_184614_ca();
                if (stack.func_77973_b() == RegistryItems.FLUX_CONFIGURATOR) {
                    return new FluxMenu(windowId, inventory, new ItemFluxConfigurator.MenuBridge(stack));
                }
            }
            return new FluxMenu(windowId, inventory, new ItemAdminConfigurator.MenuBridge());
        }).setRegistryName("flux_menu")));
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(@Nonnull RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((IRecipeSerializer)FluxStorageRecipeSerializer.INSTANCE.setRegistryName("fluxnetworks", "flux_storage_recipe")));
        event.getRegistry().register((IForgeRegistryEntry)((IRecipeSerializer)NBTWipeRecipeSerializer.INSTANCE.setRegistryName("fluxnetworks", "nbt_wipe_recipe")));
    }

    @SubscribeEvent
    public static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        RegistrySounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void gatherData(@Nonnull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new FluxLootTableProvider(generator));
        }
    }
}

