/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.loot;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.registry.RegistryBlocks;

public class FluxBlockLootTables
extends BlockLootTables {
    private final Set<Block> knownBlocks = new ObjectArraySet();

    @Nonnull
    public final Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected final void func_218507_a(@Nonnull Block blockIn, @Nonnull LootTable.Builder table) {
        super.func_218507_a(blockIn, table);
        this.knownBlocks.add(blockIn);
    }

    protected void addTables() {
        this.func_218522_a(RegistryBlocks.FLUX_PLUG, FluxBlockLootTables::fluxDropping);
        this.func_218522_a(RegistryBlocks.FLUX_POINT, FluxBlockLootTables::fluxDropping);
        this.func_218522_a(RegistryBlocks.FLUX_CONTROLLER, FluxBlockLootTables::fluxDropping);
        this.func_218522_a(RegistryBlocks.BASIC_FLUX_STORAGE, FluxBlockLootTables::fluxDropping);
        this.func_218522_a(RegistryBlocks.HERCULEAN_FLUX_STORAGE, FluxBlockLootTables::fluxDropping);
        this.func_218522_a(RegistryBlocks.GARGANTUAN_FLUX_STORAGE, FluxBlockLootTables::fluxDropping);
    }

    @Nonnull
    protected static LootTable.Builder fluxDropping(Block block) {
        if (!(block instanceof FluxDeviceBlock)) {
            throw new IllegalArgumentException();
        }
        CopyNbt.Builder copyNbt = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
        copyNbt.func_216056_a("networkID", "FluxData.networkID");
        copyNbt.func_216056_a("customName", "FluxData.customName");
        copyNbt.func_216056_a("priority", "FluxData.priority");
        copyNbt.func_216056_a("limit", "FluxData.limit");
        copyNbt.func_216056_a("surgeMode", "FluxData.surgeMode");
        copyNbt.func_216056_a("disableLimit", "FluxData.disableLimit");
        if (block instanceof FluxStorageBlock) {
            copyNbt.func_216056_a("energy", "FluxData.energy");
        } else {
            copyNbt.func_216056_a("buffer", "FluxData.buffer");
        }
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)FluxBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)copyNbt))));
    }
}

