/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class TOPIntegration
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(@Nonnull ITheOneProbe iTheOneProbe) {
        iTheOneProbe.registerProvider((IProbeInfoProvider)new FluxDeviceInfoProvider());
        iTheOneProbe.registerBlockDisplayOverride((IBlockDisplayOverride)new FluxDeviceDisplayOverride());
        return null;
    }

    public static class FluxDeviceInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "fluxnetworks";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
            if (!FluxConfig.enableOneProbeBasicInfo && !FluxConfig.enableOneProbeAdvancedInfo) {
                return;
            }
            TileEntity tile = world.func_175625_s(iProbeHitData.getPos());
            if (tile instanceof TileFluxDevice) {
                TileFluxDevice flux = (TileFluxDevice)tile;
                if (FluxConfig.enableOneProbeBasicInfo) {
                    iProbeInfo.text((ITextComponent)(flux.getNetwork().isValid() ? new StringTextComponent(TextFormatting.AQUA + flux.getNetwork().getNetworkName()) : new StringTextComponent(TextFormatting.AQUA + FluxTranslate.ERROR_NO_SELECTED.t())));
                    iProbeInfo.text((ITextComponent)new StringTextComponent(FluxUtils.getTransferInfo(flux, EnergyType.FE)));
                    if (playerEntity.func_225608_bj_()) {
                        if (flux.getDeviceType().isStorage()) {
                            iProbeInfo.text((ITextComponent)FluxTranslate.ENERGY_STORED.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + EnergyType.storage(flux.getTransferBuffer())));
                        } else {
                            iProbeInfo.text((ITextComponent)FluxTranslate.INTERNAL_BUFFER.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + EnergyType.storage(flux.getTransferBuffer())));
                        }
                    }
                }
                if (FluxConfig.enableOneProbeAdvancedInfo && (!FluxConfig.enableOneProbeSneaking || playerEntity.func_225608_bj_())) {
                    if (flux.getDisableLimit()) {
                        iProbeInfo.text((ITextComponent)FluxTranslate.TRANSFER_LIMIT.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + (Object)((Object)FluxTranslate.UNLIMITED)));
                    } else {
                        iProbeInfo.text((ITextComponent)FluxTranslate.TRANSFER_LIMIT.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + EnergyType.storage(flux.getRawLimit())));
                    }
                    if (flux.getSurgeMode()) {
                        iProbeInfo.text((ITextComponent)FluxTranslate.PRIORITY.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + (Object)((Object)FluxTranslate.SURGE)));
                    } else {
                        iProbeInfo.text((ITextComponent)FluxTranslate.PRIORITY.getTextComponent().func_240702_b_(": " + TextFormatting.GREEN + flux.getRawPriority()));
                    }
                    if (flux.isForcedLoading()) {
                        iProbeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.GOLD + FluxTranslate.FORCED_LOADING.t()));
                    }
                }
            }
        }
    }

    public static class FluxDeviceDisplayOverride
    implements IBlockDisplayOverride {
        public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, @Nonnull World world, @Nonnull BlockState blockState, @Nonnull IProbeHitData iProbeHitData) {
            TileEntity tile = world.func_175625_s(iProbeHitData.getPos());
            if (tile instanceof TileFluxDevice) {
                TileFluxDevice flux = (TileFluxDevice)tile;
                ItemStack itemStack = flux.getDisplayStack();
                CompoundNBT tag = itemStack.func_190925_c("FluxData");
                tag.func_74768_a("networkID", flux.getNetworkID());
                tag.func_74778_a("customName", flux.getCustomName());
                iProbeInfo.horizontal().item(itemStack).vertical().itemLabel(itemStack).text((ITextComponent)new StringTextComponent(TextStyleClass.MODNAME + "Flux Networks"));
                return true;
            }
            return false;
        }
    }
}

