/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.device.IFluxPlug;
import sonar.fluxnetworks.api.device.IFluxPoint;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.common.capability.SuperAdmin;
import sonar.fluxnetworks.common.connection.BasicFluxNetwork;
import sonar.fluxnetworks.common.connection.PhantomFluxDevice;
import sonar.fluxnetworks.common.connection.PriorityGroup;
import sonar.fluxnetworks.common.connection.TransferIterator;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class FluxNetworkServer
extends BasicFluxNetwork {
    private final Map<FluxLogicType, List<? extends IFluxDevice>> connections = new EnumMap<FluxLogicType, List<? extends IFluxDevice>>(FluxLogicType.class);
    private final Queue<IFluxDevice> toAdd = new LinkedList<IFluxDevice>();
    private final Queue<IFluxDevice> toRemove = new LinkedList<IFluxDevice>();
    private boolean sortConnections = true;
    private final List<PriorityGroup<IFluxPlug>> sortedPlugs = new ArrayList<PriorityGroup<IFluxPlug>>();
    private final List<PriorityGroup<IFluxPoint>> sortedPoints = new ArrayList<PriorityGroup<IFluxPoint>>();
    private final TransferIterator<IFluxPlug> plugTransferIterator = new TransferIterator(false);
    private final TransferIterator<IFluxPoint> pointTransferIterator = new TransferIterator(true);
    private long bufferLimiter = 0L;

    public FluxNetworkServer() {
    }

    public FluxNetworkServer(int id, String name, int color, PlayerEntity creator) {
        super(id, name, color, creator);
    }

    private void handleConnectionQueue() {
        IFluxDevice device;
        while ((device = this.toAdd.poll()) != null) {
            for (FluxLogicType type : FluxLogicType.getValidTypes(device)) {
                this.sortConnections |= FluxUtils.addWithCheck(this.getConnections(type), device);
            }
        }
        while ((device = this.toRemove.poll()) != null) {
            for (FluxLogicType type : FluxLogicType.getValidTypes(device)) {
                this.sortConnections |= this.getConnections(type).remove(device);
            }
        }
        if (this.sortConnections) {
            this.sortConnections();
            this.sortConnections = false;
        }
    }

    private void sortConnections() {
        this.sortedPlugs.clear();
        this.sortedPoints.clear();
        List<IFluxPlug> plugs = this.getConnections(FluxLogicType.PLUG);
        List<IFluxPoint> points = this.getConnections(FluxLogicType.POINT);
        plugs.forEach(p -> PriorityGroup.getOrCreateGroup(p.getLogicPriority(), this.sortedPlugs).getDevices().add(p));
        points.forEach(p -> PriorityGroup.getOrCreateGroup(p.getLogicPriority(), this.sortedPoints).getDevices().add(p));
        this.sortedPlugs.sort(PriorityGroup.DESCENDING_ORDER);
        this.sortedPoints.sort(PriorityGroup.DESCENDING_ORDER);
    }

    @Override
    @Nonnull
    public <T extends IFluxDevice> List<T> getConnections(FluxLogicType type) {
        return this.connections.computeIfAbsent(type, m -> new ArrayList());
    }

    @Override
    public void onEndServerTick() {
        this.statistics.startProfiling();
        this.handleConnectionQueue();
        this.bufferLimiter = 0L;
        List devices = this.getConnections(FluxLogicType.ANY);
        for (IFluxDevice f : devices) {
            f.getTransferHandler().onCycleStart();
        }
        if (!this.sortedPoints.isEmpty() && !this.sortedPlugs.isEmpty()) {
            this.plugTransferIterator.reset(this.sortedPlugs);
            this.pointTransferIterator.reset(this.sortedPoints);
            block1: while (this.pointTransferIterator.hasNext()) {
                while (this.plugTransferIterator.hasNext()) {
                    IFluxPlug plug = (IFluxPlug)this.plugTransferIterator.next();
                    IFluxPoint point = (IFluxPoint)this.pointTransferIterator.next();
                    if (plug.getDeviceType() == point.getDeviceType()) break block1;
                    long operate = plug.getTransferHandler().removeFromBuffer(point.getTransferHandler().getRequest());
                    if (operate > 0L) {
                        point.getTransferHandler().addToBuffer(operate);
                        continue block1;
                    }
                    this.plugTransferIterator.incrementFlux();
                }
                break block1;
            }
        }
        for (IFluxDevice f : devices) {
            f.getTransferHandler().onCycleEnd();
            this.bufferLimiter += f.getTransferHandler().getRequest();
        }
        this.statistics.stopProfiling();
    }

    @Override
    public long getBufferLimiter() {
        return this.bufferLimiter;
    }

    @Override
    public void markSortConnections() {
        this.sortConnections = true;
    }

    @Override
    @Nonnull
    public AccessLevel getPlayerAccess(PlayerEntity player) {
        if (FluxConfig.enableSuperAdmin && SuperAdmin.isPlayerSuperAdmin(player)) {
            return AccessLevel.SUPER_ADMIN;
        }
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        Optional<NetworkMember> member = this.getMemberByUUID(uuid);
        if (member.isPresent()) {
            return member.get().getAccessLevel();
        }
        return this.security.isEncrypted() ? AccessLevel.BLOCKED : AccessLevel.USER;
    }

    @Override
    public void onDelete() {
        this.getConnections(FluxLogicType.ANY).forEach(IFluxDevice::disconnect);
        this.connections.clear();
        this.toAdd.clear();
        this.toRemove.clear();
        this.sortedPlugs.clear();
        this.sortedPoints.clear();
    }

    @Override
    public void enqueueConnectionAddition(@Nonnull IFluxDevice device) {
        if (device instanceof PhantomFluxDevice) {
            throw new IllegalStateException();
        }
        if (this.getConnections(FluxLogicType.ANY).contains(device)) {
            return;
        }
        if (!this.toAdd.contains(device)) {
            this.toAdd.offer(device);
            this.toRemove.remove(device);
            this.allConnections.put((Object)device.getGlobalPos(), (Object)device);
        }
    }

    @Override
    public void enqueueConnectionRemoval(@Nonnull IFluxDevice device, boolean chunkUnload) {
        if (device instanceof PhantomFluxDevice) {
            throw new IllegalArgumentException();
        }
        if (this.getConnections(FluxLogicType.ANY).contains(device) && !this.toRemove.contains(device)) {
            this.toRemove.offer(device);
            this.toAdd.remove(device);
            if (chunkUnload) {
                this.allConnections.put((Object)device.getGlobalPos(), (Object)new PhantomFluxDevice(device));
            } else {
                this.allConnections.remove((Object)device.getGlobalPos());
            }
        }
    }
}

