/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class FluxConnectorBlock
extends FluxDeviceBlock
implements IWaterLoggable {
    public static final BooleanProperty[] SIDES_CONNECTED = new BooleanProperty[]{BlockStateProperties.field_208150_C, BlockStateProperties.field_208149_B, BlockStateProperties.field_208151_D, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, BlockStateProperties.field_208152_E};

    public FluxConnectorBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208150_C, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.FALSE)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE));
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        Direction dir;
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        TileFluxDevice tile = (TileFluxDevice)worldIn.func_175625_s(pos);
        if (tile != null && !tile.getFluxWorld().field_72995_K && (dir = FluxUtils.getBlockDirection(pos, fromPos)) != null) {
            tile.updateTransfers(dir);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        Direction dir;
        super.onNeighborChange(state, world, pos, neighbor);
        TileFluxDevice tile = (TileFluxDevice)world.func_175625_s(pos);
        if (tile != null && !tile.getFluxWorld().field_72995_K && (dir = FluxUtils.getBlockDirection(pos, neighbor)) != null) {
            tile.updateTransfers(dir);
        }
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a((Property[])SIDES_CONNECTED);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    @Nonnull
    public FluidState func_204507_t(@Nonnull BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

