/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.jei.CreatingFluxRecipeType;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;

public class CreatingFluxRecipeCategory
implements IRecipeCategory<CreatingFluxRecipeType> {
    public static final ResourceLocation CATEGORY_UUID = new ResourceLocation("fluxnetworks", "creating_flux");
    public static final ResourceLocation TEXTURES = new ResourceLocation("fluxnetworks", "textures/gui/gui_creating_flux_recipe.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer timer;

    public CreatingFluxRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, -20, 128, 80);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RegistryItems.FLUX_DUST));
        this.timer = guiHelper.createTickTimer(60, 320, false);
    }

    @Nonnull
    public static List<CreatingFluxRecipeType> getRecipes() {
        ArrayList<CreatingFluxRecipeType> recipes = new ArrayList<CreatingFluxRecipeType>();
        recipes.add(new CreatingFluxRecipeType(Blocks.field_150357_h, Blocks.field_150343_Z, new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)RegistryItems.FLUX_DUST)));
        recipes.add(new CreatingFluxRecipeType(RegistryBlocks.FLUX_BLOCK, Blocks.field_150343_Z, new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)RegistryItems.FLUX_DUST)));
        return recipes;
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)RegistryItems.FLUX_DUST)});
    }

    @Nonnull
    public ResourceLocation getUid() {
        return CATEGORY_UUID;
    }

    @Nonnull
    public Class<? extends CreatingFluxRecipeType> getRecipeClass() {
        return CreatingFluxRecipeType.class;
    }

    @Nonnull
    public String getTitle() {
        return FluxTranslate.JEI_CREATING_FLUX.t();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull CreatingFluxRecipeType recipe, @Nonnull IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(@Nonnull IRecipeLayout iRecipeLayout, @Nonnull CreatingFluxRecipeType recipe, @Nonnull IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 8, 24);
        guiItemStacks.init(1, false, 102, 24);
        guiItemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    @Nonnull
    public List<ITextComponent> getTooltipStrings(@Nonnull CreatingFluxRecipeType recipe, double mouseX, double mouseY) {
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY < 64.0) {
            return Lists.newArrayList((Object[])new ITextComponent[]{new StringTextComponent("Y+2 = ").func_230529_a_((ITextComponent)recipe.getCrusher().getBlock().func_235333_g_()), new StringTextComponent("Y+1 = ").func_230529_a_(recipe.getInput().func_200301_q()), new StringTextComponent("Y+0 = ").func_230529_a_((ITextComponent)recipe.getBase().getBlock().func_235333_g_())});
        }
        return Collections.emptyList();
    }

    public void draw(@Nonnull CreatingFluxRecipeType recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        matrixStack.func_227860_a_();
        int value = this.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        matrixStack.func_227861_a_(52.0, 10.0 + offset, 128.0);
        matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        matrixStack.func_227863_a_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderBlock(recipe.getCrusher().func_176223_P(), matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(52.0, 40.0, 96.0);
        matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        matrixStack.func_227863_a_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderBlock(recipe.getBase().func_176223_P(), matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(63.0, 36.0, 112.0);
        matrixStack.func_227862_a_(16.0f, -16.0f, 16.0f);
        ItemStack toDisplay = value > 160 ? recipe.getOutput() : recipe.getInput();
        matrixStack.func_227863_a_(new Quaternion(toDisplay.func_77973_b() instanceof BlockItem ? 30.0f : 0.0f, -90.0f + 180.0f * ((float)value / (float)this.timer.getMaxValue()), 0.0f, true));
        itemRenderer.func_229110_a_(toDisplay, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, (IRenderTypeBuffer)buffer);
        matrixStack.func_227865_b_();
        buffer.func_228461_a_();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String help = FluxTranslate.JEI_LEFT_CLICK.format(recipe.getCrusher().getBlock().func_235333_g_().getString());
        fontRenderer.func_238421_b_(matrixStack, help, 64.0f - (float)fontRenderer.func_78256_a(help) / 2.0f, 68.0f, -12566464);
    }
}

