/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;
import sonar.fluxnetworks.register.NetworkHandler;

public class GuiFluxDeviceHome
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoading;
    private final TileFluxDevice tileEntity;
    private int timer;

    public GuiFluxDeviceHome(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.tileEntity = (TileFluxDevice)container.bridge;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_HOME;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_HOME, this.navigationTabs);
        this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 8, 135, 12, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
        this.func_230480_a_((Widget)this.redirectButton);
        int color = this.network.getNetworkColor() | 0xFF000000;
        this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 28, 144, 12).setOutlineColor(color);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(this.tileEntity.getCustomName());
        this.fluxName.func_212954_a(string -> {
            this.tileEntity.setCustomName(this.fluxName.func_146179_b());
            NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)1);
        });
        this.func_230480_a_((Widget)this.fluxName);
        this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 45, 144, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.priority.func_146203_f(5);
        this.priority.func_146180_a(String.valueOf(this.tileEntity.getRawPriority()));
        this.priority.func_212954_a(string -> {
            this.tileEntity.setPriority(this.priority.getValidInt());
            NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)2);
        });
        this.func_230480_a_((Widget)this.priority);
        this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 62, 144, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(this.tileEntity.getMaxTransferLimit());
        this.limit.func_146203_f(9);
        this.limit.func_146180_a(String.valueOf(this.tileEntity.getRawLimit()));
        this.limit.func_212954_a(string -> {
            this.tileEntity.setTransferLimit(this.limit.getValidLong());
            NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)3);
        });
        this.func_230480_a_((Widget)this.limit);
        this.surge = new SlidedSwitchButton(140, 120, 1, this.field_147003_i, this.field_147009_r, this.tileEntity.getSurgeMode());
        this.disableLimit = new SlidedSwitchButton(140, 132, 2, this.field_147003_i, this.field_147009_r, this.tileEntity.getDisableLimit());
        this.switches.add(this.surge);
        this.switches.add(this.disableLimit);
        if (!this.tileEntity.getDeviceType().isStorage()) {
            this.chunkLoading = new SlidedSwitchButton(140, 144, 3, this.field_147003_i, this.field_147009_r, this.tileEntity.isForcedLoading());
            this.switches.add(this.chunkLoading);
        }
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        this.screenUtils.renderNetwork(matrixStack, this.network.getNetworkName(), this.network.getNetworkColor(), 20, 8);
        this.renderTransfer(matrixStack, this.tileEntity);
        this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 89.0f, 150.0f, FluxClientCache.getFeedbackColor());
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SURGE_MODE.t(), 20.0f, 120.0f, this.network.getNetworkColor());
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 132.0f, this.network.getNetworkColor());
        if (!this.tileEntity.getDeviceType().isStorage()) {
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.CHUNK_LOADING.t(), 20.0f, 144.0f, this.network.getNetworkColor());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof SlidedSwitchButton) {
            SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
            switch (switchButton.id) {
                case 1: {
                    switchButton.switchButton();
                    this.tileEntity.setSurgeMode(switchButton.toggled);
                    NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)4);
                    break;
                }
                case 2: {
                    switchButton.switchButton();
                    this.tileEntity.setDisableLimit(switchButton.toggled);
                    NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)5);
                    break;
                }
                case 3: {
                    this.tileEntity.setForcedLoading(!switchButton.toggled);
                    NetworkHandler.C2S_TileEntity(this.tileEntity, (byte)6);
                }
            }
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timer == 0) {
            NetworkHandler.C2S_RequestNetworkUpdate(this.network, 21);
        }
        if (this.chunkLoading != null) {
            this.chunkLoading.toggled = this.tileEntity.isForcedLoading();
        }
        ++this.timer;
        this.timer %= 100;
    }
}

