/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.api.network.AccessLevel;

public class NetworkMember {
    private UUID playerUUID;
    private String cachedName;
    private AccessLevel accessLevel;

    private NetworkMember() {
    }

    public NetworkMember(CompoundNBT nbt) {
        this.readNBT(nbt);
    }

    public static NetworkMember create(PlayerEntity player, AccessLevel accessLevel) {
        NetworkMember t = new NetworkMember();
        GameProfile profile = player.func_146103_bH();
        t.playerUUID = PlayerEntity.func_146094_a((GameProfile)profile);
        t.cachedName = profile.getName();
        t.accessLevel = accessLevel;
        return t;
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void readNBT(@Nonnull CompoundNBT nbt) {
        this.playerUUID = nbt.func_186857_a("playerUUID");
        this.cachedName = nbt.func_74779_i("cachedName");
        this.accessLevel = AccessLevel.values()[nbt.func_74771_c("accessLevel")];
    }

    public void writeNBT(@Nonnull CompoundNBT nbt) {
        nbt.func_186854_a("playerUUID", this.playerUUID);
        nbt.func_74778_a("cachedName", this.cachedName);
        nbt.func_74774_a("accessLevel", (byte)this.accessLevel.ordinal());
    }
}

