/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import malte0811.ferritecore.impl.Deduplicator;
import malte0811.ferritecore.util.PredicateHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyValueConditionImpl {
    private static final Map<Pair<Property<?>, Comparable<?>>, Predicate<BlockState>> STATE_HAS_PROPERTY_CACHE = new ConcurrentHashMap();

    public static Predicate<BlockState> getPredicate(StateContainer<Block, BlockState> stateContainer, String key, String value, Splitter splitter) {
        Predicate<BlockState> isMatchedState;
        List matchedStates;
        boolean invert;
        Property property = stateContainer.func_185920_a(key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", key, ((Block)stateContainer.func_177622_c()).toString()));
        }
        String valueNoInvert = value;
        boolean bl = invert = !valueNoInvert.isEmpty() && valueNoInvert.charAt(0) == '!';
        if (invert) {
            valueNoInvert = valueNoInvert.substring(1);
        }
        if ((matchedStates = splitter.splitToList((CharSequence)valueNoInvert)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", value, key, ((Block)stateContainer.func_177622_c()).toString()));
        }
        if (matchedStates.size() == 1) {
            isMatchedState = PropertyValueConditionImpl.makePropertyPredicate(stateContainer, property, valueNoInvert, key, value);
        } else {
            List<Predicate<BlockState>> subPredicates = matchedStates.stream().map(subValue -> PropertyValueConditionImpl.makePropertyPredicate(stateContainer, property, subValue, key, value)).collect(Collectors.toList());
            PredicateHelper.canonize(subPredicates);
            isMatchedState = Deduplicator.or(subPredicates);
        }
        return invert ? isMatchedState.negate() : isMatchedState;
    }

    private static <T extends Comparable<T>> Predicate<BlockState> makePropertyPredicate(StateContainer<Block, BlockState> container, Property<T> property, String subValue, String key, String value) {
        Optional optional = property.func_185929_b(subValue);
        if (!optional.isPresent()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", subValue, key, ((Block)container.func_177622_c()).toString(), value));
        }
        Comparable unwrapped = (Comparable)optional.get();
        return STATE_HAS_PROPERTY_CACHE.computeIfAbsent(Pair.of(property, (Object)unwrapped), pair -> {
            Comparable valueInt = (Comparable)pair.getRight();
            Property propInt = (Property)pair.getLeft();
            return state -> state.func_177229_b(propInt).equals(valueInt);
        });
    }
}

