/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import malte0811.ferritecore.ducks.BlockStateCacheAccess;
import malte0811.ferritecore.hash.VoxelShapeArrayHash;
import malte0811.ferritecore.hash.VoxelShapeHash;
import malte0811.ferritecore.mixin.blockstatecache.VSArrayAccess;
import malte0811.ferritecore.mixin.blockstatecache.VSSplitAccess;
import malte0811.ferritecore.mixin.blockstatecache.VoxelShapeAccess;
import malte0811.ferritecore.util.Constants;
import net.minecraft.block.AbstractBlock;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.shapes.SplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeArray;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateCacheImpl {
    public static final Map<VoxelShapeArray, VoxelShapeArray> CACHE_COLLIDE = new Object2ObjectOpenCustomHashMap((Hash.Strategy)VoxelShapeArrayHash.INSTANCE);
    public static final Map<VoxelShape, Pair<VoxelShape, VoxelShape[]>> CACHE_PROJECT = new Object2ObjectOpenCustomHashMap((Hash.Strategy)VoxelShapeHash.INSTANCE);
    private static final LazyValue<Function<AbstractBlock.AbstractBlockState, BlockStateCacheAccess>> GET_CACHE = new LazyValue(() -> {
        try {
            Field cacheField = AbstractBlock.AbstractBlockState.class.getDeclaredField(Constants.blockstateCacheFieldName);
            cacheField.setAccessible(true);
            MethodHandle getter = MethodHandles.lookup().unreflectGetter(cacheField);
            return state -> {
                try {
                    return getter.invoke((AbstractBlock.AbstractBlockState)state);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            };
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    });
    private static final ThreadLocal<BlockStateCacheAccess> LAST_CACHE = new ThreadLocal();

    public static void deduplicateCachePre(AbstractBlock.AbstractBlockState state) {
        LAST_CACHE.set((BlockStateCacheAccess)((Function)GET_CACHE.func_179281_c()).apply(state));
    }

    public static void deduplicateCachePost(AbstractBlock.AbstractBlockState state) {
        BlockStateCacheAccess newCache = (BlockStateCacheAccess)((Function)GET_CACHE.func_179281_c()).apply(state);
        if (newCache != null) {
            BlockStateCacheAccess oldCache = LAST_CACHE.get();
            BlockStateCacheImpl.deduplicateCollisionShape(newCache, oldCache);
            BlockStateCacheImpl.deduplicateRenderShapes(newCache, oldCache);
            LAST_CACHE.set(null);
        }
    }

    private static void deduplicateCollisionShape(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        VoxelShape dedupedCollisionShape;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(oldCache.getCollisionShape(), newCache.getCollisionShape())) {
            dedupedCollisionShape = oldCache.getCollisionShape();
        } else {
            dedupedCollisionShape = newCache.getCollisionShape();
            if (dedupedCollisionShape instanceof VoxelShapeArray) {
                dedupedCollisionShape = (VoxelShape)CACHE_COLLIDE.computeIfAbsent((VoxelShapeArray)dedupedCollisionShape, Function.identity());
            }
        }
        BlockStateCacheImpl.replaceInternals(dedupedCollisionShape, newCache.getCollisionShape());
        newCache.setCollisionShape(dedupedCollisionShape);
    }

    private static void deduplicateRenderShapes(BlockStateCacheAccess newCache, @Nullable BlockStateCacheAccess oldCache) {
        Pair newPair;
        VoxelShape oldRenderShape;
        VoxelShape newRenderShape = BlockStateCacheImpl.getRenderShape(newCache.getOcclusionShapes());
        if (newRenderShape == null) {
            return;
        }
        Pair dedupedRenderShapes = null;
        if (oldCache != null && VoxelShapeHash.INSTANCE.equals(newRenderShape, oldRenderShape = BlockStateCacheImpl.getRenderShape(oldCache.getOcclusionShapes()))) {
            dedupedRenderShapes = Pair.of((Object)oldRenderShape, (Object)oldCache.getOcclusionShapes());
        }
        if (dedupedRenderShapes == null && (dedupedRenderShapes = CACHE_PROJECT.putIfAbsent(newRenderShape, (Pair<VoxelShape, VoxelShape[]>)(newPair = Pair.of((Object)newRenderShape, (Object)newCache.getOcclusionShapes())))) == null) {
            dedupedRenderShapes = newPair;
        }
        BlockStateCacheImpl.replaceInternals((VoxelShape)dedupedRenderShapes.getLeft(), newRenderShape);
        newCache.setOcclusionShapes((VoxelShape[])dedupedRenderShapes.getRight());
    }

    private static void replaceInternals(VoxelShape toKeep, VoxelShape toReplace) {
        if (toKeep instanceof VoxelShapeArray && toReplace instanceof VoxelShapeArray) {
            BlockStateCacheImpl.replaceInternals((VoxelShapeArray)toKeep, (VoxelShapeArray)toReplace);
        }
    }

    public static void replaceInternals(VoxelShapeArray toKeep, VoxelShapeArray toReplace) {
        if (toKeep == toReplace) {
            return;
        }
        BlockStateCacheImpl.access(toReplace).setXs(BlockStateCacheImpl.access(toKeep).getXs());
        BlockStateCacheImpl.access(toReplace).setYs(BlockStateCacheImpl.access(toKeep).getYs());
        BlockStateCacheImpl.access(toReplace).setZs(BlockStateCacheImpl.access(toKeep).getZs());
        BlockStateCacheImpl.accessVS((VoxelShape)toReplace).setFaces(BlockStateCacheImpl.accessVS((VoxelShape)toKeep).getFaces());
        BlockStateCacheImpl.accessVS((VoxelShape)toReplace).setShape(BlockStateCacheImpl.accessVS((VoxelShape)toKeep).getShape());
    }

    private static VSArrayAccess access(VoxelShapeArray a) {
        return (VSArrayAccess)a;
    }

    private static VoxelShapeAccess accessVS(VoxelShape a) {
        return (VoxelShapeAccess)a;
    }

    @Nullable
    private static VoxelShape getRenderShape(@Nullable VoxelShape[] projected) {
        if (projected != null) {
            for (VoxelShape side : projected) {
                if (!(side instanceof SplitVoxelShape)) continue;
                return ((VSSplitAccess)side).getDelegate();
            }
        }
        return null;
    }
}

