/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.fansmod.tiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import xyz.przemyk.fansmod.Config;
import xyz.przemyk.fansmod.registry.TileEntities;
import xyz.przemyk.fansmod.tiles.FanTile;

public class StickyFanTile
extends FanTile {
    protected AxisAlignedBB stickyScan;

    public StickyFanTile() {
        super((TileEntityType<? extends FanTile>)((TileEntityType)TileEntities.STICKY_FAN_TILE.get()));
    }

    @Override
    protected int getMaxRange() {
        return (Integer)Config.GOLD_FAN_RANGE.get();
    }

    @Override
    protected double getFanSpeed() {
        return (Double)Config.GOLD_FAN_SPEED.get();
    }

    @Override
    protected void firstTick() {
        super.firstTick();
        this.stickyScan = this.getScanDouble((Double)Config.STICKY_RANGE.get());
    }

    @Override
    protected void moveEntities() {
        List entityList = this.field_145850_b.func_217357_a(Entity.class, this.scan);
        List stickyEntityList = this.field_145850_b.func_217357_a(Entity.class, this.stickyScan);
        for (Entity entity : entityList) {
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75100_b || stickyEntityList.contains(entity)) continue;
            this.addMotion(entity);
            if (this.fanDirection != Direction.UP) continue;
            entity.field_70143_R = 0.0f;
        }
    }

    protected AxisAlignedBB getScanDouble(double boxLength) {
        switch (this.fanDirection) {
            case DOWN: 
            case NORTH: 
            case WEST: {
                Vector3d max = StickyFanTile.offsetVec3d(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.fanDirection, boxLength + 1.0).func_72441_c(1.0, 1.0, 1.0);
                return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), max.field_72450_a, max.field_72448_b, max.field_72449_c);
            }
        }
        Vector3d max2 = StickyFanTile.offsetVec3d(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.fanDirection, boxLength).func_72441_c(1.0, 1.0, 1.0);
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), max2.field_72450_a, max2.field_72448_b, max2.field_72449_c);
    }

    public static Vector3d offsetVec3d(double x, double y, double z, Direction facing, double n) {
        return n == 0.0 ? new Vector3d(x, y, z) : new Vector3d(x + (double)facing.func_82601_c() * n, y + (double)facing.func_96559_d() * n, z + (double)facing.func_82599_e() * n);
    }
}

