/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.fansmod.tiles;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import xyz.przemyk.fansmod.registry.Items;

public abstract class FanTile
extends TileEntity
implements ITickableTileEntity {
    protected boolean firstTick = true;
    protected int range;
    protected Direction fanDirection;
    protected AxisAlignedBB scan;

    protected FanTile(TileEntityType<? extends FanTile> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected abstract double getFanSpeed();

    protected abstract int getMaxRange();

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            if (this.firstTick) {
                this.firstTick = false;
                this.firstTick();
            }
            this.getRange();
            if (this.range > 0) {
                this.scan = this.getScan(this.range);
                this.moveEntities();
            }
        }
    }

    protected void firstTick() {
        this.getDirection();
    }

    protected void getRange() {
        for (int i = 1; i <= this.getMaxRange(); ++i) {
            BlockPos scanPos = this.field_174879_c.func_177967_a(this.fanDirection, i);
            BlockState blockState = this.field_145850_b.func_180495_p(scanPos);
            if (!blockState.func_224755_d((IBlockReader)this.field_145850_b, scanPos, this.fanDirection.func_176734_d()) && !blockState.func_224755_d((IBlockReader)this.field_145850_b, scanPos, this.fanDirection)) continue;
            this.range = i - 1;
            return;
        }
        this.range = this.getMaxRange();
    }

    protected void getDirection() {
        this.fanDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    protected AxisAlignedBB getScan(int boxLength) {
        switch (this.fanDirection) {
            case DOWN: 
            case NORTH: 
            case WEST: {
                return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177967_a(this.fanDirection, boxLength + 1).func_177963_a(1.0, 1.0, 1.0));
            }
        }
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177967_a(this.fanDirection, boxLength).func_177963_a(1.0, 1.0, 1.0));
    }

    protected void moveEntities() {
        List entityList = this.field_145850_b.func_217357_a(Entity.class, this.scan);
        for (Entity entity : entityList) {
            if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
                this.addMotion(entity);
            }
            if (this.fanDirection != Direction.UP) continue;
            entity.field_70143_R = 0.0f;
        }
    }

    protected void addMotion(Entity entity) {
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184582_a(EquipmentSlotType.FEET).func_77973_b() == Items.STICKY_BOOTS_ITEM.get() && entity.func_233570_aj_()) {
            return;
        }
        Vector3d motion = entity.func_213322_ci();
        switch (this.fanDirection) {
            case DOWN: {
                entity.func_213293_j(motion.field_72450_a, motion.field_72448_b - this.getFanSpeed(), motion.field_72449_c);
                break;
            }
            case UP: {
                entity.func_213293_j(motion.field_72450_a, motion.field_72448_b + this.getFanSpeed(), motion.field_72449_c);
                break;
            }
            case NORTH: {
                entity.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c - this.getFanSpeed());
                break;
            }
            case SOUTH: {
                entity.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c + this.getFanSpeed());
                break;
            }
            case WEST: {
                entity.func_213293_j(motion.field_72450_a - this.getFanSpeed(), motion.field_72448_b, motion.field_72449_c);
                break;
            }
            case EAST: {
                entity.func_213293_j(motion.field_72450_a + this.getFanSpeed(), motion.field_72448_b, motion.field_72449_c);
            }
        }
    }
}

