/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.screen;

import java.util.List;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class TickableText {
    protected int ticks = 0;
    protected final String message;
    protected final int color;
    protected final boolean newline;
    protected final float tickRate;

    public TickableText(String message, int color, boolean newline, float tickRate) {
        this.message = message;
        this.color = color;
        this.newline = newline;
        this.tickRate = tickRate;
    }

    public TickableText(String message, int color) {
        this(message, color, true, 1.0f);
    }

    public void tick() {
        ++this.ticks;
    }

    public TickableText setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public void render(class_327 font, class_332 graphics, int x, int y) {
        graphics.method_25303(font, this.message.substring(0, class_3532.method_15386((float)Math.min((float)this.ticks * this.tickRate, (float)this.message.length()))), x, y, this.color);
    }

    public int getMaxUsefulTicks() {
        return class_3532.method_15375((float)((float)this.message.length() / this.tickRate));
    }

    public void reset() {
        this.ticks = 0;
    }

    public boolean isDone() {
        return (float)this.ticks * this.tickRate >= (float)this.message.length();
    }

    public boolean causesNewLine() {
        return this.newline;
    }

    public int getWidth(class_327 font) {
        return font.method_1727(this.message);
    }

    public static void tickList(List<TickableText> texts) {
        for (int i = 0; i < texts.size(); ++i) {
            TickableText txt = texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
    }
}

