/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.menu;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.mixin.getters.AbstractContainerMenuInvoker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class QuickMoveHandler {
    protected List<QuickMoveRule> rules = new ArrayList<QuickMoveRule>();

    public class_1799 quickMoveStack(IExposedContainer container, class_1657 player, int index) {
        if (this.rules.isEmpty()) {
            throw new RuntimeException("Quick Move requires at least one rule to be registered");
        }
        class_1799 slotStackCopy = class_1799.field_8037;
        class_1735 slot = container.getMenuSlot(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            slotStackCopy = slotStack.method_7972();
            boolean matched = false;
            for (QuickMoveRule rule : this.rules) {
                if (!rule.req.test(slotStack, index)) continue;
                if (!container.moveMenuItemStackTo(slotStack, rule.startIdx, rule.endIdx, rule.reversed)) {
                    return class_1799.field_8037;
                }
                container.onQuickMove(slotStackCopy, slotStack, slot);
                matched = true;
                break;
            }
            if (!matched) {
                Placebo.LOGGER.error("Failed to perform a quick move for container {}, which would have resulted in an infinite loop!", (Object)container);
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return slotStackCopy;
    }

    public void registerRule(BiPredicate<class_1799, Integer> req, int startIdx, int endIdx, boolean reversed) {
        this.rules.add(new QuickMoveRule(req, startIdx, endIdx, reversed));
    }

    public void registerRule(BiPredicate<class_1799, Integer> req, int startIdx, int endIdx) {
        this.registerRule(req, startIdx, endIdx, false);
    }

    public static interface IExposedContainer {
        default public boolean moveMenuItemStackTo(class_1799 pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
            return ((AbstractContainerMenuInvoker)((Object)this))._moveItemStackTo(pStack, pStartIndex, pEndIndex, pReverseDirection);
        }

        default public class_1735 getMenuSlot(int index) {
            return ((class_1703)this).method_7611(index);
        }

        default public void onQuickMove(class_1799 original, class_1799 remaining, class_1735 slot) {
            slot.method_7668();
        }
    }

    protected record QuickMoveRule(BiPredicate<class_1799, Integer> req, int startIdx, int endIdx, boolean reversed) {
    }
}

