/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.commands;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.shadowsoffire.placebo.mixin.getters.MinecraftServerAccessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3039;
import net.minecraft.class_52;
import net.minecraft.class_5270;

public class SerializeLootTableCommand {
    public static final Gson GSON = class_5270.method_27862().setPrettyPrinting().create();
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"fakerlib.cmd.not_found", (Object[])new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"serialize_loot_table").requires(s -> s.method_9259(2))).then(class_2170.method_9244((String)"loot_table", (ArgumentType)class_2232.method_9441()).suggests(class_3039.field_13605).executes(ctx -> {
            class_2960 id = class_2232.method_9443((CommandContext)ctx, (String)"loot_table");
            class_52 table = ((MinecraftServerAccessor)((class_2168)ctx.getSource()).method_9211()).getResources().comp_353().method_29469().getLootTable(id);
            if (table == class_52.field_948) {
                throw NOT_FOUND.create((Object)id);
            }
            String path = "fakerlib_serialized/" + id.method_12836() + "/loot_tables/" + id.method_12832() + ".json";
            File file = new File(FabricLoader.getInstance().getGameDir().toFile(), path);
            file.getParentFile().mkdirs();
            if (SerializeLootTableCommand.attemptSerialize(table, file)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"fakerlib.cmd.serialize_success", (Object[])new Object[]{id, path}), true);
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"fakerlib.cmd.serialize_failure"));
            }
            return 0;
        })));
    }

    public static boolean attemptSerialize(class_52 table, File file) {
        String json = GSON.toJson((Object)table);
        try (FileWriter w = new FileWriter(file);){
            w.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

