/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Carpet;
import carpet.script.external.VanillaClient;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.shapes.ShapeDirection;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_602;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class ShapesRenderer {
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> shapes;
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> labels;
    private final class_310 client;
    private final Map<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> renderedShapes = new HashMap<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>(){
        {
            this.put("line", RenderedLine::new);
            this.put("box", RenderedBox::new);
            this.put("sphere", RenderedSphere::new);
            this.put("cylinder", RenderedCylinder::new);
            this.put("label", RenderedText::new);
            this.put("polygon", RenderedPolyface::new);
            this.put("block", (c, s) -> new RenderedSprite((class_310)c, (ShapeDispatcher.ExpiringShape)s, false));
            this.put("item", (c, s) -> new RenderedSprite((class_310)c, (ShapeDispatcher.ExpiringShape)s, true));
        }
    };

    public static void rotatePoseStackByShapeDirection(class_4587 poseStack, ShapeDirection shapeDirection, class_4184 camera, class_243 objectPos) {
        switch (shapeDirection) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case CAMERA: {
                poseStack.method_22907(camera.method_23767());
                break;
            }
            case PLAYER: {
                class_243 vector = objectPos.method_1020(camera.method_19326());
                double x = vector.field_1352;
                double y = vector.field_1351;
                double z = vector.field_1350;
                double d = Math.sqrt(x * x + z * z);
                float rotX = (float)Math.atan2(x, z);
                float rotY = (float)Math.atan2(y, d);
                poseStack.method_22907(class_7833.field_40716.rotation(rotX));
                poseStack.method_22907(class_7833.field_40714.rotation(-rotY));
            }
        }
    }

    public ShapesRenderer(class_310 minecraftClient) {
        this.client = minecraftClient;
        this.shapes = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
        this.labels = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
    }

    public void render(class_4587 matrices, class_4184 camera, float partialTick) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        class_638 iWorld = this.client.field_1687;
        class_5321 dimensionType = iWorld.method_27983();
        if ((this.shapes.get(dimensionType) == null || this.shapes.get(dimensionType).isEmpty()) && (this.labels.get(dimensionType) == null || this.labels.get(dimensionType).isEmpty())) {
            return;
        }
        long currentTime = this.client.field_1687.method_8510();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        double cameraZ = camera.method_19326().field_1350;
        boolean entityBoxes = this.client.method_1561().method_3958();
        if (!this.shapes.isEmpty()) {
            this.shapes.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            matrixStack.method_34425(matrices.method_23760().method_23761());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.lineWidth((float)0.5f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)0.1f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderFaces(tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)1.0f);
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
        if (!this.labels.isEmpty()) {
            this.labels.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            this.labels.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                }
            });
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        token.run();
    }

    public void addShapes(class_2499 tag) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        int count = tag.size();
        for (int i = 0; i < count; ++i) {
            this.addShape(tag.method_10602(i));
        }
        token.run();
    }

    public void addShape(class_2487 tag) {
        ShapeDispatcher.ExpiringShape shape = ShapeDispatcher.fromTag(tag, (class_1937)this.client.field_1687);
        if (shape == null) {
            return;
        }
        BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>> shapeFactory = this.renderedShapes.get(tag.method_10558("shape"));
        if (shapeFactory == null) {
            CarpetScriptServer.LOG.info("Unrecognized shape: " + tag.method_10558("shape"));
        } else {
            RenderedShape<? extends ShapeDispatcher.ExpiringShape> rshape = shapeFactory.apply(this.client, shape);
            class_5321<class_1937> dim = shape.shapeDimension;
            long key = rshape.key();
            Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> container = rshape.stageDeux() ? this.labels : this.shapes;
            RenderedShape existing = (RenderedShape)container.computeIfAbsent(dim, d -> new Long2ObjectOpenHashMap()).get(key);
            if (existing != null) {
                existing.promoteWith(rshape);
            } else {
                container.get(dim).put(key, rshape);
            }
        }
    }

    public void reset() {
        this.shapes.values().forEach(Long2ObjectOpenHashMap::clear);
        this.labels.values().forEach(Long2ObjectOpenHashMap::clear);
    }

    public void renewShapes() {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        this.shapes.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        this.labels.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        token.run();
    }

    public static void drawLine(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, float red1, float grn1, float blu1, float alpha) {
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
        builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        tessellator.method_1350();
    }

    public static void drawBoxWireGLLines(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha, float red2, float grn2, float blu2) {
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        if (xthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn2, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn2, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        if (ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red2, grn1, blu2, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red2, grn1, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        if (zthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red2, grn2, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red2, grn2, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        tessellator.method_1350();
    }

    public static void drawBoxFaces(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha) {
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (xthick && ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (zthick) {
                builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        if (zthick && ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (xthick) {
                builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        if (zthick && xthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (ythick) {
                builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        tessellator.method_1350();
    }

    public static void drawCylinderWireframe(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        int hsteps = 1;
        float hstep = 1.0f;
        if (!isFlat) {
            hsteps = (int)Math.ceil(class_3532.method_15379((float)h) / (step * r)) + 1;
            hstep = h / (float)(hsteps - 1);
        }
        if (axis == class_2350.class_2351.field_11052) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360 + 1; ++i) {
                    float theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    float y = hh;
                    float z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy + 0.0f), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy + h), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + h), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx - x), (double)cy, (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)cy, (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11048) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float z = r * class_3532.method_15362((float)theta);
                    float x = hh;
                    float y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + 0.0f), (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)cx, (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)cx, (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11051) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    float z = hh;
                    float x = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        }
    }

    public static void drawCylinderFaces(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        if (axis == class_2350.class_2351.field_11052) {
            float z;
            float x;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)(x + cx), (double)cy, (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)cx, (double)(cy + h), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(cy + h), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float xp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i2 = 1; i2 <= num_steps360; ++i2) {
                    float theta2 = step * (float)i2;
                    float x2 = r * class_3532.method_15362((float)theta2);
                    float z2 = r * class_3532.method_15374((float)theta2);
                    builder.method_22912((double)(cx + xp), (double)(cy + 0.0f), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + xp), (double)(cy + h), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x2), (double)(cy + h), (double)(cz + z2)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x2), (double)(cy + 0.0f), (double)(cz + z2)).method_22915(red, grn, blu, alpha).method_1344();
                    xp = x2;
                    zp = z2;
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11048) {
            float z;
            float y;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                y = r * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)cx, (double)(cy + y), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)(cx + h), (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + h), (double)(cy + y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float yp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i3 = 1; i3 <= num_steps360; ++i3) {
                    float theta3 = step * (float)i3;
                    float y2 = r * class_3532.method_15362((float)theta3);
                    float z3 = r * class_3532.method_15374((float)theta3);
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + yp), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + yp), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + y2), (double)(cz + z3)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + y2), (double)(cz + z3)).method_22915(red, grn, blu, alpha).method_1344();
                    yp = y2;
                    zp = z3;
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11051) {
            float y;
            float x;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * class_3532.method_15362((float)theta);
                y = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)(x + cx), (double)(cy + y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)cx, (double)cy, (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(cy + y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float xp = r;
                float yp = 0.0f;
                for (int i4 = 1; i4 <= num_steps360; ++i4) {
                    float theta4 = step * (float)i4;
                    float x3 = r * class_3532.method_15362((float)theta4);
                    float y3 = r * class_3532.method_15374((float)theta4);
                    builder.method_22912((double)(cx + xp), (double)(cy + yp), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + xp), (double)(cy + yp), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x3), (double)(cy + y3), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x3), (double)(cy + y3), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    xp = x3;
                    yp = y3;
                }
                tessellator.method_1350();
            }
        }
    }

    public static void drawSphereWireframe(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float y;
        float z;
        float x;
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        for (int i = 0; i <= num_steps360; ++i) {
            builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
            float theta = step * (float)i;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = step * (float)j;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
        }
        for (int j = 0; j <= num_steps180; ++j) {
            builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
            float phi = step * (float)j;
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
        }
    }

    public static void drawSphereFaces(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        for (int i = 0; i <= num_steps360; ++i) {
            float theta = (float)i * step;
            float thetaprime = theta + step;
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = r;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = (float)j * step;
                float x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                float z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                float y = r * class_3532.method_15362((float)phi);
                float xp = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)thetaprime);
                float zp = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)thetaprime);
                builder.method_22912((double)(xb + cx), (double)(yp + cy), (double)(zb + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(xbp + cx), (double)(yp + cy), (double)(zbp + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(xp + cx), (double)(y + cy), (double)(zp + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
            tessellator.method_1350();
        }
    }

    public static abstract class RenderedShape<T extends ShapeDispatcher.ExpiringShape> {
        protected T shape;
        protected class_310 client;
        long expiryTick;
        double renderEpsilon;

        public abstract void renderLines(class_4587 var1, class_289 var2, class_287 var3, double var4, double var6, double var8, float var10);

        public void renderFaces(class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
        }

        protected RenderedShape(class_310 client, T shape) {
            this.shape = shape;
            this.client = client;
            this.expiryTick = client.field_1687.method_8510() + (long)((ShapeDispatcher.ExpiringShape)shape).getExpiry();
            this.renderEpsilon = (3.0 + (double)this.key() / 9.223372036854776E18) / 1000.0;
        }

        public boolean isExpired(long currentTick) {
            return this.expiryTick < currentTick;
        }

        public long key() {
            return ((ShapeDispatcher.ExpiringShape)this.shape).key(this.client.field_1687.method_30349());
        }

        public boolean shouldRender(class_5321<class_1937> dim) {
            if (((ShapeDispatcher.ExpiringShape)this.shape).followEntity <= 0) {
                return true;
            }
            if (this.client.field_1687 == null) {
                return false;
            }
            if (this.client.field_1687.method_27983() != dim) {
                return false;
            }
            return this.client.field_1687.method_8469(((ShapeDispatcher.ExpiringShape)this.shape).followEntity) != null;
        }

        public boolean stageDeux() {
            return false;
        }

        public void promoteWith(RenderedShape<?> rshape) {
            this.expiryTick = rshape.expiryTick;
        }
    }

    public static class RenderedCylinder
    extends RenderedShape<ShapeDispatcher.Cylinder> {
        public RenderedCylinder(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Cylinder)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderWireframe(tessellator, bufferBuilder, (float)(vc.field_1352 - cx - dir * this.renderEpsilon), (float)(vc.field_1351 - cy - dir * this.renderEpsilon), (float)(vc.field_1350 - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).r, ((ShapeDispatcher.Cylinder)this.shape).g, ((ShapeDispatcher.Cylinder)this.shape).b, ((ShapeDispatcher.Cylinder)this.shape).a);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderFaces(tessellator, bufferBuilder, (float)(vc.field_1352 - cx - dir * this.renderEpsilon), (float)(vc.field_1351 - cy - dir * this.renderEpsilon), (float)(vc.field_1350 - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).fr, ((ShapeDispatcher.Cylinder)this.shape).fg, ((ShapeDispatcher.Cylinder)this.shape).fb, ((ShapeDispatcher.Cylinder)this.shape).fa);
        }
    }

    public static class RenderedSphere
    extends RenderedShape<ShapeDispatcher.Sphere> {
        public RenderedSphere(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Sphere)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereWireframe(tessellator, bufferBuilder, (float)(vc.field_1352 - cx), (float)(vc.field_1351 - cy), (float)(vc.field_1350 - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).r, ((ShapeDispatcher.Sphere)this.shape).g, ((ShapeDispatcher.Sphere)this.shape).b, ((ShapeDispatcher.Sphere)this.shape).a);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereFaces(tessellator, bufferBuilder, (float)(vc.field_1352 - cx), (float)(vc.field_1351 - cy), (float)(vc.field_1350 - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).fr, ((ShapeDispatcher.Sphere)this.shape).fg, ((ShapeDispatcher.Sphere)this.shape).fb, ((ShapeDispatcher.Sphere)this.shape).fa);
        }
    }

    public static class RenderedPolyface
    extends RenderedShape<ShapeDispatcher.Polyface> {
        private static final class_293.class_5596[] faceIndices = new class_293.class_5596[]{class_293.class_5596.field_27377, class_293.class_5596.field_27378, class_293.class_5596.field_29344, class_293.class_5596.field_29345, class_293.class_5596.field_27379, class_293.class_5596.field_27380, class_293.class_5596.field_27381, class_293.class_5596.field_27382};

        public RenderedPolyface(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Polyface)shape);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).fa == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            bufferBuilder.method_1328(faceIndices[((ShapeDispatcher.Polyface)this.shape).mode], class_290.field_1576);
            for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                class_243 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                }
                bufferBuilder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).fr, ((ShapeDispatcher.Polyface)this.shape).fg, ((ShapeDispatcher.Polyface)this.shape).fb, ((ShapeDispatcher.Polyface)this.shape).fa).method_1344();
            }
            tessellator.method_1350();
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).a == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 6) {
                class_243 vec;
                int i;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                class_243 vec0 = null;
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                    if (i == 0) {
                        vec0 = vec;
                    }
                    builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                }
                builder.method_22912(vec0.method_10216() - cx, vec0.method_10214() - cy, vec0.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                tessellator.method_1350();
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                    for (i = 1; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                        }
                        builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                        builder.method_22912(vec0.method_10216() - cx, vec0.method_10214() - cy, vec0.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    }
                    tessellator.method_1350();
                }
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 5) {
                int i;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                class_243 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(1);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(1).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                }
                builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); i += 2) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                    builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                }
                i = ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1;
                i -= 1 - i % 2;
                while (i > 0) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                    builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    i -= 2;
                }
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    for (i = 2; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                        }
                        builder.method_22912(vec.method_10216() - cx, vec.method_10214() - cy, vec.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    }
                }
                tessellator.method_1350();
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 4) {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    class_243 vecA = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecA = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecA, partialTick);
                    }
                    class_243 vecB = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecB = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecB, partialTick);
                    }
                    class_243 vecC = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecC = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecC, partialTick);
                    }
                    builder.method_22912(vecA.method_10216() - cx, vecA.method_10214() - cy, vecA.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    builder.method_22912(vecB.method_10216() - cx, vecB.method_10214() - cy, vecB.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    builder.method_22912(vecB.method_10216() - cx, vecB.method_10214() - cy, vecB.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    builder.method_22912(vecC.method_10216() - cx, vecC.method_10214() - cy, vecC.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    builder.method_22912(vecC.method_10216() - cx, vecC.method_10214() - cy, vecC.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                    builder.method_22912(vecA.method_10216() - cx, vecA.method_10214() - cy, vecA.method_10215() - cz).method_22915(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a).method_1344();
                }
                tessellator.method_1350();
            }
        }
    }

    public static class RenderedLine
    extends RenderedShape<ShapeDispatcher.Line> {
        public RenderedLine(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Line)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            class_243 v1 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).to, partialTick);
            ShapesRenderer.drawLine(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), ((ShapeDispatcher.Line)this.shape).r, ((ShapeDispatcher.Line)this.shape).g, ((ShapeDispatcher.Line)this.shape).b, ((ShapeDispatcher.Line)this.shape).a);
        }
    }

    public static class RenderedBox
    extends RenderedShape<ShapeDispatcher.Box> {
        private RenderedBox(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Box)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxWireGLLines(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b, ((ShapeDispatcher.Box)this.shape).a, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).fa == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxFaces(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).fr, ((ShapeDispatcher.Box)this.shape).fg, ((ShapeDispatcher.Box)this.shape).fb, ((ShapeDispatcher.Box)this.shape).fa);
        }
    }

    public static class RenderedText
    extends RenderedShape<ShapeDispatcher.DisplayedText> {
        protected RenderedText(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.DisplayedText)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedText)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.DisplayedText)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.DisplayedText)this.shape).pos, partialTick);
            class_4184 camera1 = this.client.field_1773.method_19418();
            class_327 textRenderer = this.client.field_1772;
            if (((ShapeDispatcher.DisplayedText)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            matrices.method_22903();
            matrices.method_22904(v1.field_1352 - cx, v1.field_1351 - cy, v1.field_1350 - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedText)this.shape).facing, camera1, v1);
            matrices.method_22905(((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, -((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, ((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f);
            if (((ShapeDispatcher.DisplayedText)this.shape).tilt != 0.0f) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).lean != 0.0f) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).turn != 0.0f) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).turn));
            }
            matrices.method_22904((double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).indent), (double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).height - 9.0f), -10.0 * this.renderEpsilon - (double)(10.0f * ((ShapeDispatcher.DisplayedText)this.shape).raise));
            matrices.method_22905(-1.0f, 1.0f, 1.0f);
            float text_x = 0.0f;
            if (((ShapeDispatcher.DisplayedText)this.shape).align == 0) {
                text_x = (float)(-textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString())) / 2.0f;
            } else if (((ShapeDispatcher.DisplayedText)this.shape).align == 1) {
                text_x = -textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString());
            }
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)builder);
            textRenderer.method_30882(((ShapeDispatcher.DisplayedText)this.shape).value, text_x, 0.0f, ((ShapeDispatcher.DisplayedText)this.shape).textcolor, false, matrices.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, ((ShapeDispatcher.DisplayedText)this.shape).textbck, 0xF000F0);
            immediate.method_22993();
            matrices.method_22909();
            RenderSystem.enableCull();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        @Override
        public void promoteWith(RenderedShape<?> rshape) {
            super.promoteWith(rshape);
            try {
                ((ShapeDispatcher.DisplayedText)this.shape).value = ((ShapeDispatcher.DisplayedText)rshape.shape).value;
            }
            catch (ClassCastException ignored) {
                CarpetScriptServer.LOG.error("shape " + rshape.shape.getClass() + " cannot cast to a Label");
            }
        }
    }

    public static class RenderedSprite
    extends RenderedShape<ShapeDispatcher.DisplayedSprite> {
        private final boolean isitem;
        private class_811 transformType = class_811.field_4315;
        private class_2338 blockPos;
        private class_2680 blockState;
        private class_2586 BlockEntity = null;

        protected RenderedSprite(class_310 client, ShapeDispatcher.ExpiringShape shape, boolean isitem) {
            super(client, (ShapeDispatcher.DisplayedSprite)shape);
            this.isitem = isitem;
            if (isitem) {
                this.transformType = class_811.valueOf((String)((ShapeDispatcher.DisplayedSprite)shape).itemTransformType.toUpperCase(Locale.ROOT));
            }
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedSprite)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.DisplayedSprite)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.DisplayedSprite)this.shape).pos, partialTick);
            class_4184 camera1 = this.client.field_1773.method_19418();
            matrices.method_22903();
            if (!this.isitem) {
                matrices.method_22904(0.5, 0.5, 0.5);
            }
            matrices.method_22904(v1.field_1352 - cx, v1.field_1351 - cy, v1.field_1350 - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedSprite)this.shape).facing, camera1, this.isitem ? v1 : v1.method_1031(0.5, 0.5, 0.5));
            if (((ShapeDispatcher.DisplayedSprite)this.shape).tilt != 0.0f) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).lean != 0.0f) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).turn != 0.0f) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(((ShapeDispatcher.DisplayedSprite)this.shape).turn));
            }
            matrices.method_22905(((ShapeDispatcher.DisplayedSprite)this.shape).scaleX, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleY, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleZ);
            if (!this.isitem) {
                matrices.method_22904(-0.5, -0.5, -0.5);
            } else {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            this.blockPos = class_2338.method_49638((class_2374)v1);
            int light = 0;
            if (this.client.field_1687 != null) {
                light = class_765.method_23687((int)(((ShapeDispatcher.DisplayedSprite)this.shape).blockLight < 0 ? this.client.field_1687.method_8314(class_1944.field_9282, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).blockLight), (int)(((ShapeDispatcher.DisplayedSprite)this.shape).skyLight < 0 ? this.client.field_1687.method_8314(class_1944.field_9284, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).skyLight));
            }
            this.blockState = ((ShapeDispatcher.DisplayedSprite)this.shape).blockState;
            class_4597.class_4598 immediate = this.client.method_22940().method_23000();
            if (!this.isitem) {
                class_827 blockEntityRenderer;
                class_2586 color22;
                class_2248 color22;
                if (this.blockState.method_26217() == class_2464.field_11458) {
                    class_1087 bakedModel = this.client.method_1541().method_3349(this.blockState);
                    int color22 = this.client.method_1505().method_1697(this.blockState, (class_1920)this.client.field_1687, this.blockPos, 0);
                    float red = (float)(color22 >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color22 >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color22 & 0xFF) / 255.0f;
                    this.client.method_1541().method_3350().method_3367(matrices.method_23760(), immediate.getBuffer(class_4696.method_23683((class_2680)this.blockState, (boolean)false)), this.blockState, bakedModel, red, green, blue, light, class_4608.field_21444);
                }
                if (this.BlockEntity == null && (color22 = this.blockState.method_26204()) instanceof class_2343) {
                    class_2343 eb = (class_2343)color22;
                    this.BlockEntity = eb.method_10123(this.blockPos, this.blockState);
                    if (this.BlockEntity != null) {
                        this.BlockEntity.method_31662((class_1937)this.client.field_1687);
                        if (((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity != null) {
                            this.BlockEntity.method_11014(((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity);
                        }
                    }
                }
                if ((color22 = this.BlockEntity) instanceof class_2627) {
                    class_2627 sbBlockEntity = (class_2627)color22;
                    this.sbrender(sbBlockEntity, partialTick, matrices, (class_4597)immediate, light, class_4608.field_21444);
                } else if (this.BlockEntity != null && (blockEntityRenderer = this.client.method_31975().method_3550(this.BlockEntity)) != null) {
                    blockEntityRenderer.method_3569(this.BlockEntity, partialTick, matrices, (class_4597)immediate, light, class_4608.field_21444);
                }
            } else if (((ShapeDispatcher.DisplayedSprite)this.shape).item != null) {
                this.client.method_1480().method_23178(((ShapeDispatcher.DisplayedSprite)this.shape).item, this.transformType, light, class_4608.field_21444, matrices, (class_4597)immediate, (class_1937)this.client.field_1687, (int)((ShapeDispatcher.DisplayedSprite)this.shape).key(this.client.field_1687.method_30349()));
            }
            matrices.method_22909();
            immediate.method_22993();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        public void sbrender(class_2627 shulkerBoxBlockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
            class_1767 dyeColor;
            class_2680 blockState;
            class_2350 direction = class_2350.field_11036;
            if (shulkerBoxBlockEntity.method_11002() && (blockState = shulkerBoxBlockEntity.method_11010()).method_26204() instanceof class_2480) {
                direction = (class_2350)blockState.method_11654((class_2769)class_2480.field_11496);
            }
            class_4730 material = (dyeColor = shulkerBoxBlockEntity.method_11320()) == null ? class_4722.field_21710 : (class_4730)class_4722.field_21711.get(dyeColor.method_7789());
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22905(0.9995f, 0.9995f, 0.9995f);
            poseStack.method_22907(direction.method_23224());
            poseStack.method_22905(1.0f, -1.0f, -1.0f);
            poseStack.method_22904(0.0, -1.0, 0.0);
            class_602<?> model = VanillaClient.ShulkerBoxRenderer_model((class_827<class_2627>)this.client.method_31975().method_3550((class_2586)shulkerBoxBlockEntity));
            class_630 modelPart = model.method_2829();
            modelPart.method_2851(0.0f, 24.0f - shulkerBoxBlockEntity.method_11312(f) * 0.5f * 16.0f, 0.0f);
            modelPart.field_3675 = 270.0f * shulkerBoxBlockEntity.method_11312(f) * ((float)Math.PI / 180);
            class_4588 vertexConsumer = material.method_24145(multiBufferSource, class_1921::method_23578);
            model.method_2828(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
    }
}

