/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.AbstractListValue;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.ThreadValue;
import carpet.script.value.Value;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ValueCaster<R>
implements ValueConverter<R> {
    private static final Map<Class<? extends Value>, ValueCaster<? extends Value>> byResult = new HashMap<Class<? extends Value>, ValueCaster<? extends Value>>();
    private final Class<R> outputType;
    private final String typeName;

    private ValueCaster(Class<R> outputType, String typeName) {
        this.outputType = outputType;
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public static <R> ValueCaster<R> get(Class<R> outputType) {
        return byResult.get(outputType);
    }

    @Override
    @Nullable
    public R convert(Value value, @Nullable Context context) {
        if (!this.outputType.isInstance(value)) {
            return null;
        }
        return (R)value;
    }

    public static <R extends Value> void register(Class<R> valueClass, String typeName) {
        ValueCaster<R> caster = new ValueCaster<R>(valueClass, typeName);
        byResult.putIfAbsent(valueClass, caster);
    }

    static {
        ValueCaster.register(Value.class, "value");
        ValueCaster.register(BlockValue.class, "block");
        ValueCaster.register(EntityValue.class, "entity");
        ValueCaster.register(FormattedTextValue.class, "formatted text");
        ValueCaster.register(FunctionValue.class, "function");
        ValueCaster.register(ListValue.class, "list");
        ValueCaster.register(MapValue.class, "map");
        ValueCaster.register(AbstractListValue.class, "list or similar");
        ValueCaster.register(NBTSerializableValue.class, "nbt object");
        ValueCaster.register(NumericValue.class, "number");
        ValueCaster.register(BooleanValue.class, "boolean");
        ValueCaster.register(StringValue.class, "string");
        ValueCaster.register(ThreadValue.class, "thread");
    }
}

