/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class DataManager
implements ISoundLists {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadData() {
        DataManager.loadMuffledMap().forEach((R, F) -> muffledSounds.put(new ResourceLocation(R), F));
        if (!Config.getDisableAchors()) {
            anchorList.clear();
            anchorList.addAll(DataManager.loadAnchors());
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!Config.getDisableAchors()) {
            DataManager.saveAnchors();
        }
    }

    private static String getWorldName() {
        if (Minecraft.func_71410_x().func_147104_D() != null) {
            return Minecraft.func_71410_x().func_147104_D().field_78847_a;
        }
        if (Minecraft.func_71410_x().func_71401_C() != null) {
            return Minecraft.func_71410_x().func_71401_C().func_240793_aU_().func_76065_j();
        }
        return "ServerWorld";
    }

    private static CompoundNBT serializeAnchor(Anchor anchor) {
        CompoundNBT anchorNBT = new CompoundNBT();
        CompoundNBT muffledNBT = new CompoundNBT();
        anchorNBT.func_74768_a("ID", anchor.getAnchorId());
        anchorNBT.func_74778_a("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.func_218657_a("POS", (INBT)NBTUtil.func_186859_a((BlockPos)anchor.getAnchorPos()));
        anchorNBT.func_74778_a("DIM", anchor.getDimension().toString());
        anchorNBT.func_74768_a("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, F) -> muffledNBT.func_74776_a(R.toString(), F.floatValue()));
        anchorNBT.func_218657_a("MUFFLED", (INBT)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeAnchor(CompoundNBT nbt) {
        TreeMap<String, Float> muffledSounds = new TreeMap<String, Float>();
        CompoundNBT muffledNBT = nbt.func_74775_l("MUFFLED");
        for (String key : muffledNBT.func_150296_c()) {
            muffledSounds.put(key, Float.valueOf(muffledNBT.func_74760_g(key)));
        }
        if (!nbt.func_74764_b("POS")) {
            return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"));
        }
        return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"), NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("POS")), new ResourceLocation(nbt.func_74779_i("DIM")), nbt.func_74762_e("RAD"), muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Float> loadMuffledMap() {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            Map map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Float>>(){}.getType());
            return map;
        }
        catch (JsonSyntaxException | IOException e) {
            return new HashMap<String, Float>();
        }
    }

    private static void saveAnchors() {
        new File("ESM/", DataManager.getWorldName()).mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)anchorList));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Anchor> loadAnchors() {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);){
            List list = (List)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<List<Anchor>>(){}.getType());
            return list;
        }
        catch (JsonSyntaxException | IOException ignored) {
            return IntStream.range(0, 10).mapToObj(i -> new Anchor(i, "Anchor " + i)).collect(Collectors.toList());
        }
    }
}

