/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins;

import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.gui.MainScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundMixin
implements ISoundLists {
    @Inject(method={"calculateVolume"}, at={@At(value="RETURN")}, cancellable=true)
    private void calculateSoundVolume(ISound sound, CallbackInfoReturnable<Float> cir) {
        if (SoundMixin.isForbidden(sound) || PlaySoundButton.isFromPSB()) {
            return;
        }
        recentSoundsList.add(sound.func_147650_b());
        if (MainScreen.isMuffled()) {
            if (muffledSounds.containsKey(sound.func_147650_b())) {
                cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * ((Float)muffledSounds.get(sound.func_147650_b())).floatValue()));
                return;
            }
            if (Config.getDisableAchors()) {
                return;
            }
            Anchor anchor = Anchor.getAnchor(sound);
            if (anchor != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * ((Float)anchor.getMuffledSounds().get(sound.func_147650_b())).floatValue()));
            }
        }
    }

    private static boolean isForbidden(ISound sound) {
        for (String fs : forbiddenSounds) {
            if (!sound.func_147650_b().toString().contains(fs)) continue;
            return true;
        }
        return false;
    }
}

