/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui.buttons;

import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.gui.MainScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class MuffledSlider
extends Widget
implements ISoundLists,
IColorsGui {
    private final String mainTitle = "ESM - Main Screen";
    private float sliderValue;
    private Button btnToggleSound;
    private PlaySoundButton btnPlaySound;
    private final ResourceLocation sound;
    public static ResourceLocation tickSound;
    public static boolean showSlider;

    public MuffledSlider(int x, int y, int width, int height, float sliderValue, ResourceLocation sound, String screenTitle, Anchor anchor) {
        super(x, y, width, height, ITextComponent.func_244388_a((String)(sound.func_110623_a() + ":" + sound.func_110624_b())));
        this.sliderValue = sliderValue;
        this.sound = sound;
        this.setBtnToggleSound(screenTitle, sound, anchor);
        this.setBtnPlaySound(sound);
    }

    @ParametersAreNonnullByDefault
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(SoundMuffler.getGui());
        this.drawGradient(matrixStack);
        float v = this.getFGColor() == 0xFFFFFF ? 213.0f : 202.0f;
        MuffledSlider.func_238463_a_((MatrixStack)matrixStack, (int)this.btnToggleSound.field_230690_l_, (int)this.btnToggleSound.field_230691_m_, (float)43.0f, (float)v, (int)11, (int)11, (int)256, (int)256);
        MuffledSlider.func_238463_a_((MatrixStack)matrixStack, (int)this.btnPlaySound.field_230690_l_, (int)this.btnPlaySound.field_230691_m_, (float)32.0f, (float)202.0f, (int)11, (int)11, (int)256, (int)256);
        this.drawMessage(matrixStack, minecraft);
    }

    private void drawMessage(MatrixStack matrixStack, Minecraft minecraft) {
        FontRenderer font = minecraft.field_71466_p;
        int v = Math.max(this.field_230688_j_, font.func_78256_a(this.func_230458_i_().getString()));
        if (showSlider && this.func_230999_j_() && this.field_230692_n_) {
            MuffledSlider.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)font, (String)("Volume: " + (int)(this.sliderValue * 100.0f)), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + 2), (int)0xFFFFFF);
        } else {
            String msgTruncated;
            if (this.field_230692_n_) {
                msgTruncated = this.func_230458_i_().getString();
                font.getClass();
                MuffledSlider.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ + 3), (int)this.field_230691_m_, (int)(this.field_230690_l_ + v + 3), (int)(this.field_230691_m_ + 9 + 2), (int)darkBG);
            } else {
                msgTruncated = font.func_238417_a_((ITextProperties)this.func_230458_i_(), 205).getString();
            }
            font.func_238405_a_(matrixStack, msgTruncated, (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 2), this.getFGColor());
        }
    }

    private void drawGradient(MatrixStack matrixStack) {
        if (this.getFGColor() == 65535) {
            MuffledSlider.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ - 1), (float)0.0f, (float)234.0f, (int)((int)(this.sliderValue * (float)(this.field_230688_j_ - 6)) + 5), (int)(this.field_230689_k_ + 1), (int)256, (int)256);
            if (this.field_230692_n_) {
                MuffledSlider.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + (int)(this.sliderValue * (float)(this.field_230688_j_ - 6)) + 1), (int)(this.field_230691_m_ + 1), (float)32.0f, (float)224.0f, (int)5, (int)9, (int)256, (int)256);
            }
        }
    }

    private void setBtnToggleSound(String screenTitle, ResourceLocation sound, Anchor anchor) {
        int x = Config.getLeftButtons() ? this.field_230690_l_ - 24 : this.field_230690_l_ + this.field_230688_j_ + 5;
        this.btnToggleSound = new Button(x, this.field_230691_m_, 11, 11, StringTextComponent.field_240750_d_, b -> {
            if (this.getFGColor() == 65535) {
                if (screenTitle.equals("ESM - Main Screen")) {
                    muffledSounds.remove(sound);
                } else {
                    anchor.removeSound(sound);
                }
                super.setFGColor(0xFFFFFF);
            } else {
                if (screenTitle.equals("ESM - Main Screen")) {
                    this.setSliderValue(Config.getDefaultMuteVolume());
                    muffledSounds.put(sound, Float.valueOf(this.sliderValue));
                } else if (anchor.getAnchorPos() != null) {
                    this.setSliderValue(Config.getDefaultMuteVolume());
                    anchor.addSound(sound, this.sliderValue);
                } else {
                    return;
                }
                super.setFGColor(65535);
            }
        });
    }

    public Button getBtnToggleSound() {
        return this.btnToggleSound;
    }

    private void setBtnPlaySound(ResourceLocation sound) {
        this.btnPlaySound = new PlaySoundButton(this.btnToggleSound.field_230690_l_ + 12, this.field_230691_m_, new SoundEvent(sound));
    }

    public PlaySoundButton getBtnPlaySound() {
        return this.btnPlaySound;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f = flag ? -1.0f : 1.0f;
            this.setSliderValue(this.sliderValue + f / (float)(this.field_230688_j_ - 8));
        }
        return false;
    }

    private void changeSliderValue(float mouseX) {
        this.setSliderValue((mouseX - (float)(this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8));
    }

    private void setSliderValue(float value) {
        double d0 = this.sliderValue;
        this.sliderValue = MathHelper.func_76131_a((float)value, (float)0.0f, (float)0.9f);
        if (d0 != (double)this.sliderValue) {
            this.func_230972_a_();
        }
        this.func_230979_b_();
        this.updateVolume();
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        this.changeSliderValue((float)mouseX);
        super.func_230983_a_(mouseX, mouseY, dragX, dragY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.field_230692_n_ && this.getFGColor() == 65535) {
            this.changeSliderValue((float)mouseX);
            showSlider = true;
            this.func_230996_d_(true);
            tickSound = this.sound;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.func_230996_d_(false);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    private void updateVolume() {
        String screenTitle = MainScreen.getScreenTitle();
        if (screenTitle.equals("ESM - Main Screen")) {
            muffledSounds.replace(this.sound, Float.valueOf(this.sliderValue));
        } else {
            Objects.requireNonNull(MainScreen.getAnchorByName(screenTitle)).replaceSound(this.sound, this.sliderValue);
        }
    }

    private void func_230979_b_() {
    }

    private void func_230972_a_() {
    }

    static {
        showSlider = false;
    }
}

