/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.setup;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.client.screen.AdvancedCrafterScreen;
import edivad.extrastorage.client.screen.AdvancedCrafterScreenQuark;
import edivad.extrastorage.client.screen.AdvancedExporterScreen;
import edivad.extrastorage.client.screen.AdvancedFluidStorageBlockScreen;
import edivad.extrastorage.client.screen.AdvancedImporterScreen;
import edivad.extrastorage.client.screen.AdvancedStorageBlockScreen;
import edivad.extrastorage.container.AdvancedCrafterContainer;
import edivad.extrastorage.items.fluid.FluidStorageType;
import edivad.extrastorage.items.item.ItemStorageType;
import edivad.extrastorage.setup.EventHandler;
import edivad.extrastorage.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSetup {
    private static final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientSetup() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        boolean quarkLoaded = ModList.get().isLoaded("quark");
        for (CrafterTier crafterTier : CrafterTier.values()) {
            if (quarkLoaded) {
                ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.CRAFTER_CONTAINER.get((Object)crafterTier).get()), AdvancedCrafterScreenQuark::new);
            } else {
                ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.CRAFTER_CONTAINER.get((Object)crafterTier).get()), AdvancedCrafterScreen::new);
            }
            RenderTypeLookup.setRenderLayer((Block)((Block)Registration.CRAFTER_BLOCK.get((Object)crafterTier).get()), (RenderType)RenderType.func_228643_e_());
            String name = crafterTier.name().toLowerCase();
            String parent = "blocks/crafter/" + name + "/cutouts/";
            bakedModelOverrideRegistry.add(Registration.CRAFTER_BLOCK.get((Object)crafterTier).getId(), (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation[]{new ResourceLocation("extrastorage", parent + "side_connected"), new ResourceLocation("extrastorage", parent + "top_connected")}));
        }
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.ADVANCED_EXPORTER_CONTAINER.get()), AdvancedExporterScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.ADVANCED_IMPORTER_CONTAINER.get()), AdvancedImporterScreen::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)Registration.ADVANCED_EXPORTER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registration.ADVANCED_IMPORTER.get()), (RenderType)RenderType.func_228643_e_());
        for (Enum enum_ : ItemStorageType.values()) {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.ITEM_STORAGE_CONTAINER.get(enum_).get()), AdvancedStorageBlockScreen::new);
        }
        for (Enum enum_ : FluidStorageType.values()) {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registration.FLUID_STORAGE_CONTAINER.get(enum_).get()), AdvancedFluidStorageBlockScreen::new);
        }
        API.instance().addPatternRenderHandler(pattern -> {
            Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (container instanceof AdvancedCrafterContainer) {
                AdvancedCrafterContainer actualContainer = (AdvancedCrafterContainer)container;
                int slots = actualContainer.getTile().getTier().getSlots();
                for (int i = 0; i < slots; ++i) {
                    if (container.func_75139_a(i).func_75211_c() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = bakedModelOverrideRegistry.get(new ResourceLocation(id.func_110624_b(), id.func_110623_a()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((IBakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

