/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.ItemStorageWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.StorageNetworkNode;
import edivad.extrastorage.items.item.ItemStorageType;
import edivad.extrastorage.tiles.AdvancedStorageBlockTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AdvancedStorageNetworkNode
extends StorageNetworkNode {
    public static final ResourceLocation BLOCK_256K_ID = new ResourceLocation("extrastorage", "block_256k");
    public static final ResourceLocation BLOCK_1024K_ID = new ResourceLocation("extrastorage", "block_1024k");
    public static final ResourceLocation BLOCK_4096K_ID = new ResourceLocation("extrastorage", "block_4096k");
    public static final ResourceLocation BLOCK_16384K_ID = new ResourceLocation("extrastorage", "block_16384k");
    private final ItemStorageType type;
    private IStorageDisk<ItemStack> storage;

    public AdvancedStorageNetworkNode(World world, BlockPos pos, ItemStorageType type) {
        super(world, pos, null);
        this.type = type;
    }

    public int getEnergyUsage() {
        return 10 + this.type.ordinal() * 2;
    }

    public ResourceLocation getId() {
        switch (this.type) {
            case TIER_5: {
                return BLOCK_256K_ID;
            }
            case TIER_6: {
                return BLOCK_1024K_ID;
            }
            case TIER_7: {
                return BLOCK_4096K_ID;
            }
            case TIER_8: {
                return BLOCK_16384K_ID;
            }
        }
        return null;
    }

    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<ItemStack>)this.storage);
    }

    public void loadStorage(@Nullable PlayerEntity owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerWorld)this.world).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultItemDisk((ServerWorld)this.world, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerWorld)this.world).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerWorld)this.world).markForSaving();
        }
        this.storage = new ItemStorageWrapperStorageDisk((StorageNetworkNode)this, disk);
    }

    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("block.extrastorage.block_" + this.type.getName());
    }

    public long getStored() {
        return (Long)AdvancedStorageBlockTile.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

