/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.items;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import edivad.extrastorage.setup.ModSetup;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class ExpandedStorageDisk
extends Item
implements IStorageDiskProvider {
    private static final String ID = "ID";

    public ExpandedStorageDisk() {
        super(new Item.Properties().func_200916_a(ModSetup.extraStorageTab).func_200917_a(1));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && !stack.func_77942_o() && entityIn instanceof PlayerEntity) {
            UUID id = UUID.randomUUID();
            ServerWorld serverWorld = (ServerWorld)worldIn;
            if (this.getType() == StorageType.ITEM) {
                API.instance().getStorageDiskManager(serverWorld).set(id, API.instance().createDefaultItemDisk(serverWorld, this.getCapacity(stack), (PlayerEntity)entityIn));
            } else if (this.getType() == StorageType.FLUID) {
                API.instance().getStorageDiskManager(serverWorld).set(id, API.instance().createDefaultFluidDisk(serverWorld, this.getCapacity(stack), (PlayerEntity)entityIn));
            }
            API.instance().getStorageDiskManager(serverWorld).markForSaving();
            this.setId(stack, id);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack diskStack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_225608_bj_()) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            IStorageDisk disk = API.instance().getStorageDiskManager(serverWorld).getByStack(diskStack);
            if (disk != null && disk.getStored() == 0) {
                ItemStack part = new ItemStack((IItemProvider)this.getPart(), diskStack.func_190916_E());
                if (!playerIn.field_71071_by.func_70441_a(part.func_77946_l())) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)playerIn.func_233580_cy_().func_177958_n(), (double)playerIn.func_233580_cy_().func_177956_o(), (double)playerIn.func_233580_cy_().func_177952_p(), (ItemStack)part);
                }
                API.instance().getStorageDiskManager(serverWorld).remove(this.getId(diskStack));
                API.instance().getStorageDiskManager(serverWorld).markForSaving();
                return new ActionResult(ActionResultType.SUCCESS, (Object)new ItemStack((IItemProvider)RSItems.STORAGE_HOUSING.get()));
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)diskStack);
    }

    public void func_77624_a(ItemStack disk, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isValid(disk)) {
            UUID id = this.getId(disk);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.storage.stored", new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).func_230530_a_(Styles.GRAY));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.storage.stored_capacity", new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).func_230530_a_(Styles.GRAY));
                }
            }
            if (flagIn.func_194127_a()) {
                tooltip.add((ITextComponent)new StringTextComponent(id.toString()).func_230530_a_(Styles.GRAY));
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a(ID);
    }

    public void setId(ItemStack disk, UUID id) {
        disk.func_196082_o().func_186854_a(ID, id);
    }

    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b(ID);
    }

    protected abstract Item getPart();
}

