/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import gg.moonflower.etched.common.item.BoomboxItem;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BipedModel.class})
public class HumanoidModelMixin<T extends LivingEntity> {
    @Shadow
    public ModelRenderer field_178724_i;
    @Shadow
    public ModelRenderer field_178723_h;

    @Inject(method={"poseRightArm"}, at={@At(value="HEAD")}, cancellable=true)
    public void poseRightArm(T livingEntity, CallbackInfo ci) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            Hand playingHand = BoomboxItem.getPlayingHand(livingEntity);
            if (livingEntity.func_184591_cq() == HandSide.RIGHT && playingHand == Hand.MAIN_HAND || livingEntity.func_184591_cq() == HandSide.LEFT && playingHand == Hand.OFF_HAND) {
                this.field_178723_h.field_78795_f = (float)Math.PI;
                this.field_178723_h.field_78796_g = 0.0f;
                this.field_178723_h.field_78808_h = -0.610865f;
                ci.cancel();
            }
        }
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="HEAD")}, cancellable=true)
    public void poseLeftArm(T livingEntity, CallbackInfo ci) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            Hand playingHand = BoomboxItem.getPlayingHand(livingEntity);
            if (livingEntity.func_184591_cq() == HandSide.LEFT && playingHand == Hand.MAIN_HAND || livingEntity.func_184591_cq() == HandSide.RIGHT && playingHand == Hand.OFF_HAND) {
                this.field_178724_i.field_78795_f = (float)Math.PI;
                this.field_178724_i.field_78796_g = 0.0f;
                this.field_178724_i.field_78808_h = 0.610865f;
                ci.cancel();
            }
        }
    }

    @Inject(method={"setupAttackAnimation"}, at={@At(value="FIELD", target="Lnet/minecraft/client/model/geom/ModelPart;xRot:F", ordinal=2)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    public void setupAttackAnimation(T livingEntity, float f, CallbackInfo ci, HandSide arm, ModelRenderer part) {
        boolean rightArm;
        Hand playingHand = BoomboxItem.getPlayingHand(livingEntity);
        boolean leftArm = (livingEntity.func_184591_cq() == HandSide.LEFT && playingHand == Hand.MAIN_HAND || livingEntity.func_184591_cq() == HandSide.RIGHT && playingHand == Hand.OFF_HAND) && arm == HandSide.LEFT;
        boolean bl = rightArm = (livingEntity.func_184591_cq() == HandSide.RIGHT && playingHand == Hand.MAIN_HAND || livingEntity.func_184591_cq() == HandSide.LEFT && playingHand == Hand.OFF_HAND) && arm == HandSide.RIGHT;
        if (leftArm || rightArm) {
            ci.cancel();
        }
    }
}

