/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin;

import com.google.common.base.Suppliers;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.client.sound.EntityRecordSoundInstance;
import gg.moonflower.etched.core.hook.RecordItemHook;
import gg.moonflower.etched.core.mixin.SoundEventAccessor;
import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MusicDiscItem.class})
public abstract class RecordItemMixin
extends Item
implements PlayableRecord {
    @Unique
    private final Supplier<TrackData[]> track = Suppliers.memoize(() -> {
        TranslationTextComponent desc = new TranslationTextComponent(this.func_77658_a() + ".desc");
        String[] parts = desc.getString().split("-", 2);
        if (parts.length < 2) {
            return new TrackData[]{new TrackData(((SoundEventAccessor)RecordItemHook.getSound((MusicDiscItem)this)).getLocation().toString(), "Minecraft", (ITextComponent)desc)};
        }
        return new TrackData[]{new TrackData(((SoundEventAccessor)RecordItemHook.getSound((MusicDiscItem)this)).getLocation().toString(), parts[0].trim(), (ITextComponent)new StringTextComponent(parts[1].trim()).func_240703_c_(desc.func_150256_b()))};
    });

    private RecordItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canPlay(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<? extends ISound> createEntitySound(ItemStack stack, Entity entity, int track) {
        if (track != 0 || !(stack.func_77973_b() instanceof MusicDiscItem)) {
            return Optional.empty();
        }
        if (PlayableRecord.canShowMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())) {
            PlayableRecord.showMessage((ITextComponent)((MusicDiscItem)stack.func_77973_b()).func_234801_g_());
        }
        return Optional.of(new EntityRecordSoundInstance(((MusicDiscItem)stack.func_77973_b()).func_185075_h(), entity));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack stack, Proxy proxy, IResourceManager resourceManager) {
        ResourceLocation key = Registry.field_212630_s.func_177774_c((Object)this);
        return resourceManager.func_219533_b(new ResourceLocation(key.func_110624_b(), "models/item/etched_album_cover/" + key.func_110623_a() + ".json")) ? CompletableFuture.completedFuture(AlbumCover.of(new ResourceLocation(key.func_110624_b(), "etched_album_cover/" + key.func_110623_a()))) : CompletableFuture.completedFuture(AlbumCover.EMPTY);
    }

    @Override
    public Optional<TrackData[]> getMusic(ItemStack stack) {
        return Optional.of(this.track.get());
    }

    @Override
    public Optional<TrackData> getAlbum(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(ItemStack stack) {
        return 1;
    }
}

