/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.forge.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.data.loot.FishingLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableGen
extends ForgeLootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(() -> new FishingProvider(), (Object)LootParameterSets.field_216262_c), (Object)Pair.of(() -> new ChestProvider(), (Object)LootParameterSets.field_216261_b), (Object)Pair.of(() -> new EntityProvider(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new BlockProvider(), (Object)LootParameterSets.field_216267_h));

    public LootTableGen(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.tables;
    }

    private static class BlockProvider
    extends BlockLootTables {
        private BlockProvider() {
        }

        protected void addTables() {
            this.func_218492_c(EtchedBlocks.ETCHING_TABLE.get());
            this.func_218492_c(EtchedBlocks.ALBUM_JUKEBOX.get());
            this.func_218492_c(EtchedBlocks.RADIO.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "etched".equals(entityType.getRegistryName().func_110624_b())).collect(Collectors.toSet());
        }
    }

    private static class EntityProvider
    extends EntityLootTables {
        private EntityProvider() {
        }

        protected void addTables() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "etched".equals(entityType.getRegistryName().func_110624_b())).collect(Collectors.toSet());
        }
    }

    private static class ChestProvider
    extends ChestLootTables {
        private ChestProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }

    private static class FishingProvider
    extends FishingLootTables {
        private FishingProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }
}

