/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core;

import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.client.render.entity.JukeboxMinecartRenderer;
import gg.moonflower.etched.client.render.item.AlbumCoverItemRenderer;
import gg.moonflower.etched.client.screen.AlbumCoverScreen;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.BoomboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.BoomboxItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.sound.download.BandcampSource;
import gg.moonflower.etched.common.sound.download.SoundCloudSource;
import gg.moonflower.etched.core.EtchedConfig;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedEntities;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedRecipes;
import gg.moonflower.etched.core.registry.EtchedSounds;
import gg.moonflower.etched.core.registry.EtchedVillagers;
import gg.moonflower.pollen.api.client.render.DynamicItemRenderer;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.event.events.entity.ModifyTradesEvents;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.client.ColorRegistry;
import gg.moonflower.pollen.api.registry.client.EntityRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ItemPredicateRegistry;
import gg.moonflower.pollen.api.registry.client.ItemRendererRegistry;
import gg.moonflower.pollen.api.registry.client.ModelRegistry;
import gg.moonflower.pollen.api.registry.client.RenderTypeRegistry;
import gg.moonflower.pollen.api.registry.client.ScreenRegistry;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class Etched {
    public static final String MOD_ID = "etched";
    public static final EtchedConfig.Client CLIENT_CONFIG = (EtchedConfig.Client)ConfigManager.register((String)"etched", (PollinatedConfigType)PollinatedConfigType.CLIENT, EtchedConfig.Client::new);
    public static final Platform PLATFORM = Platform.builder((String)"etched").commonInit(Etched::commonInit).commonPostInit(Etched::commonPostInit).clientInit(Etched::clientInit).clientPostInit(Etched::clientPostInit).build();

    public static void commonInit() {
        EtchedBlocks.BLOCKS.register(PLATFORM);
        EtchedBlocks.BLOCK_ENTITIES.register(PLATFORM);
        EtchedItems.ITEMS.register(PLATFORM);
        EtchedEntities.ENTITIES.register(PLATFORM);
        EtchedMenus.MENUS.register(PLATFORM);
        EtchedSounds.SOUNDS.register(PLATFORM);
        EtchedVillagers.POI_TYPES.register(PLATFORM);
        EtchedVillagers.PROFESSIONS.register(PLATFORM);
        EtchedRecipes.RECIPES.register(PLATFORM);
        EtchedMessages.init();
        ModifyTradesEvents.VILLAGER.register(context -> {
            if (context.getProfession() != EtchedVillagers.BARD.get()) {
                return;
            }
            ModifyTradesEvents.TradeRegistry tier1 = context.getTrades(1);
            tier1.add((IItemProvider)Items.field_196156_dS, 8, 1, 4, 20, true);
            tier1.add((IItemProvider)Items.field_196189_ec, 8, 1, 4, 20, true);
            tier1.add((IItemProvider)Items.field_196158_dT, 8, 1, 4, 20, true);
            tier1.add((IItemProvider)Items.field_221664_at, 1, 2, 16, 2, true);
            tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
            ModifyTradesEvents.TradeRegistry tier2 = context.getTrades(2);
            tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
            tier2.add(EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
            ModifyTradesEvents.TradeRegistry tier3 = context.getTrades(3);
            tier3.add((IItemProvider)Blocks.field_150435_aG, 6, 1, 16, 2, false);
            tier3.add((IItemProvider)Blocks.field_150407_cf, 12, 1, 8, 2, false);
            tier3.add((IItemProvider)Blocks.field_196556_aL, 8, 1, 32, 4, false);
            tier3.add((IItemProvider)Blocks.field_189880_di, 24, 1, 8, 4, false);
            tier3.add((IItemProvider)Blocks.field_150403_cj, 36, 1, 4, 8, false);
            tier3.add((IItemProvider)Blocks.field_150340_R, 48, 1, 2, 10, false);
            ModifyTradesEvents.TradeRegistry tier4 = context.getTrades(4);
            tier3.add((IItemProvider)Items.field_221778_cy, 26, 1, 4, 30, false);
            tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
            tier4.add(EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
            ModifyTradesEvents.TradeRegistry tier5 = context.getTrades(5);
            tier5.add((IItemProvider)Items.field_151045_i, 8, 1, 8, 40, true);
            for (Item item : ItemTags.field_219774_K.func_230236_b_()) {
                tier5.add((IItemProvider)item, 10, 1, 4, 40, true);
            }
        });
    }

    public static void clientInit() {
        RegisterAtlasSpriteEvent.event((ResourceLocation)PlayerContainer.field_226615_c_).register((atlas, registry) -> {
            registry.accept(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_disc"));
            registry.accept(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_label"));
        });
        ClientLoading.load();
        ModelRegistry.registerFactory((resourceManager, out) -> {
            String folder = "models/item/etched_album_cover/";
            for (ResourceLocation animationLocation : resourceManager.func_199003_a(folder, name -> name.endsWith(".json"))) {
                out.accept(new ModelResourceLocation(new ResourceLocation(animationLocation.func_110624_b(), animationLocation.func_110623_a().substring(12, animationLocation.func_110623_a().length() - 5)), "inventory"));
            }
        });
        ColorRegistry.register((stack, index) -> index == 0 || index == 1 ? MusicLabelItem.getLabelColor(stack) : -1, (Supplier[])new Supplier[]{EtchedItems.MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index == 0 ? ComplexMusicLabelItem.getPrimaryColor(stack) : (index == 1 ? ComplexMusicLabelItem.getSecondaryColor(stack) : -1), (Supplier[])new Supplier[]{EtchedItems.COMPLEX_MUSIC_LABEL});
        ColorRegistry.register((stack, index) -> index > 0 ? -1 : ((BlankMusicDiscItem)stack.func_77973_b()).func_200886_f(stack), (Supplier[])new Supplier[]{EtchedItems.BLANK_MUSIC_DISC});
        ColorRegistry.register((stack, index) -> index == 0 ? EtchedMusicDiscItem.getDiscColor(stack) : (EtchedMusicDiscItem.getPattern(stack).isColorable() ? (index == 1 ? EtchedMusicDiscItem.getLabelPrimaryColor(stack) : (index == 2 ? EtchedMusicDiscItem.getLabelSecondaryColor(stack) : -1)) : -1), (Supplier[])new Supplier[]{EtchedItems.ETCHED_MUSIC_DISC});
        AlbumCoverItemRenderer.init();
    }

    public static void commonPostInit(Platform.ModSetupContext ctx) {
        SoundSourceManager.registerSource(new SoundCloudSource());
        SoundSourceManager.registerSource(new BandcampSource());
        ctx.enqueueWork(EtchedVillagers::registerVillages);
    }

    public static void clientPostInit(Platform.ModSetupContext ctx) {
        ctx.enqueueWork(() -> {
            ScreenRegistry.register(EtchedMenus.ETCHING_MENU.get(), EtchingScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_JUKEBOX_MENU.get(), AlbumJukeboxScreen::new);
            ScreenRegistry.register(EtchedMenus.BOOMBOX_MENU.get(), BoomboxScreen::new);
            ScreenRegistry.register(EtchedMenus.ALBUM_COVER_MENU.get(), AlbumCoverScreen::new);
            ScreenRegistry.register(EtchedMenus.RADIO_MENU.get(), RadioScreen::new);
            ItemPredicateRegistry.register((Item)EtchedItems.BOOMBOX.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "playing"), (stack, level, entity) -> {
                if (!(entity instanceof PlayerEntity)) {
                    return 0.0f;
                }
                Hand hand = BoomboxItem.getPlayingHand(entity);
                return hand != null && stack == entity.func_184586_b(hand) ? 1.0f : 0.0f;
            });
            ItemPredicateRegistry.register((Item)EtchedItems.ETCHED_MUSIC_DISC.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "pattern"), (stack, level, entity) -> MathHelper.func_76131_a((float)((float)EtchedMusicDiscItem.getPattern(stack).ordinal() / 10.0f), (float)0.0f, (float)1.0f));
        });
        RenderTypeRegistry.register((Block)EtchedBlocks.ETCHING_TABLE.get(), (RenderType)RenderType.func_228643_e_());
        RenderTypeRegistry.register((Block)EtchedBlocks.RADIO.get(), (RenderType)RenderType.func_228643_e_());
        EntityRendererRegistry.register(EtchedEntities.JUKEBOX_MINECART, JukeboxMinecartRenderer::new);
        ItemRendererRegistry.registerHandModel((IItemProvider)((IItemProvider)EtchedItems.BOOMBOX.get()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(MOD_ID, "boombox_in_hand"), "inventory"));
        ItemRendererRegistry.registerRenderer((IItemProvider)((IItemProvider)EtchedItems.ALBUM_COVER.get()), (DynamicItemRenderer)AlbumCoverItemRenderer.INSTANCE);
    }

    private static class ClientLoading {
        private ClientLoading() {
        }

        private static void load() {
            ModelRegistry.registerSpecial((ResourceLocation)new ModelResourceLocation(new ResourceLocation(Etched.MOD_ID, "boombox_in_hand"), "inventory"));
        }
    }
}

