/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.PlayableRecordItem;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.AlbumCoverMenu;
import gg.moonflower.etched.core.registry.EtchedItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class AlbumCoverItem
extends PlayableRecordItem
implements ContainerItem {
    public static final int MAX_RECORDS = 9;

    public AlbumCoverItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        return this.use(this, level, player, hand);
    }

    @Override
    public Container constructMenu(int containerId, PlayerInventory inventory, PlayerEntity player, int index) {
        return new AlbumCoverMenu(containerId, inventory, index);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        for (ItemStack record : AlbumCoverItem.getRecords(stack)) {
            if (!(record.func_77973_b() instanceof PlayableRecord)) continue;
            record.func_77973_b().func_77624_a(record, level, list, tooltipFlag);
        }
    }

    @Override
    public Optional<TrackData[]> getMusic(ItemStack stack) {
        List<ItemStack> records = AlbumCoverItem.getRecords(stack);
        return records.isEmpty() ? Optional.empty() : Optional.of((TrackData[])records.stream().filter(record -> record.func_77973_b() instanceof PlayableRecord).flatMap(record -> Arrays.stream(((PlayableRecord)record.func_77973_b()).getMusic((ItemStack)record).orElseGet(() -> new TrackData[0]))).toArray(TrackData[]::new));
    }

    @Override
    public Optional<TrackData> getAlbum(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(ItemStack stack) {
        return AlbumCoverItem.getRecords(stack).stream().filter(record -> record.func_77973_b() instanceof PlayableRecord).mapToInt(record -> ((PlayableRecord)record.func_77973_b()).getTrackCount((ItemStack)record)).sum();
    }

    public static Optional<ItemStack> getCoverStack(ItemStack stack) {
        if (stack.func_77973_b() != EtchedItems.ALBUM_COVER.get()) {
            return Optional.empty();
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("CoverRecord", 10)) {
            return Optional.empty();
        }
        ItemStack cover = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("CoverRecord"));
        return cover.func_190926_b() ? Optional.empty() : Optional.of(cover);
    }

    public static List<ItemStack> getRecords(ItemStack stack) {
        if (stack.func_77973_b() != EtchedItems.ALBUM_COVER.get()) {
            return Collections.emptyList();
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Records", 9)) {
            return Collections.emptyList();
        }
        ListNBT keysNbt = nbt.func_150295_c("Records", 10);
        if (keysNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(keysNbt.size());
        for (int i = 0; i < Math.min(9, keysNbt.size()); ++i) {
            ItemStack key = ItemStack.func_199557_a((CompoundNBT)keysNbt.func_150305_b(i));
            if (key.func_190926_b()) continue;
            list.add(key);
        }
        return list;
    }

    public static void setCover(ItemStack stack, ItemStack record) {
        if (stack.func_77973_b() != EtchedItems.ALBUM_COVER.get()) {
            return;
        }
        if (record.func_190926_b()) {
            stack.func_196083_e("CoverRecord");
            return;
        }
        stack.func_196082_o().func_218657_a("CoverRecord", (INBT)record.func_77955_b(new CompoundNBT()));
    }

    public static void setRecords(ItemStack stack, Collection<ItemStack> keys) {
        if (stack.func_77973_b() != EtchedItems.ALBUM_COVER.get() || keys.isEmpty()) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        ListNBT keysNbt = new ListNBT();
        int i = 0;
        for (ItemStack key : keys) {
            if (key.func_190926_b()) continue;
            if (i >= 9) break;
            keysNbt.add((Object)key.func_77955_b(new CompoundNBT()));
            ++i;
        }
        nbt.func_218657_a("Records", (INBT)keysNbt);
    }
}

