/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.blockentity;

import dev.architectury.injectables.annotations.PlatformOnly;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class AlbumJukeboxBlockEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int playingIndex = -1;
    private int track = 0;
    private ItemStack playingStack = ItemStack.field_190927_a;
    private boolean loaded;

    public AlbumJukeboxBlockEntity() {
        super(EtchedBlocks.ALBUM_JUKEBOX_BE.get());
    }

    private void updateState() {
        if (this.field_145850_b != null) {
            boolean hasRecord;
            boolean hasItem = false;
            for (ItemStack stack : this.func_190576_q()) {
                if (stack == ItemStack.field_190927_a) continue;
                hasItem = true;
                break;
            }
            if (hasItem != (hasRecord = ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)AlbumJukeboxBlock.HAS_RECORD)).booleanValue())) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AlbumJukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasItem)), 3);
                this.func_70296_d();
            }
        }
    }

    private void updatePlaying() {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || !this.field_145850_b.func_201670_d()) {
            return;
        }
        if (!this.loaded) {
            this.loaded = true;
            SoundTracker.playAlbum(this, this.func_195044_w(), (ClientWorld)this.field_145850_b, this.func_174877_v(), false);
        }
        if (this.isPlaying()) {
            AxisAlignedBB range = new AxisAlignedBB(this.func_174877_v()).func_186662_g(3.45);
            List livingEntities = this.field_145850_b.func_217357_a(LivingEntity.class, range);
            livingEntities.forEach(living -> living.func_191987_a(this.func_174877_v(), true));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT hbt) {
        super.func_230337_a_(state, hbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(hbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)hbt, this.items);
        }
        if (this.loaded && this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            SoundTracker.playAlbum(this, this.func_195044_w(), (ClientWorld)this.field_145850_b, this.func_174877_v(), false);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT hbt) {
        super.func_189515_b(hbt);
        if (!this.func_184282_c(hbt)) {
            ItemStackHelper.func_191282_a((CompoundNBT)hbt, this.items);
        }
        return hbt;
    }

    @PlatformOnly(value={"forge"})
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public int[] func_180463_a(Direction direction) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return PlayableRecord.isPlayableRecord(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack = super.func_70298_a(index, amount);
        this.updateState();
        if (!stack.func_190926_b()) {
            this.updatePlaying();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = super.func_70304_b(index);
        this.updateState();
        if (!stack.func_190926_b()) {
            this.updatePlaying();
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updateState();
        this.updatePlaying();
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.updateState();
        this.updatePlaying();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.etched.album_jukebox");
    }

    protected Container func_213906_a(int menuId, PlayerInventory inventory) {
        return new AlbumJukeboxMenu(menuId, inventory, (IInventory)this, this.func_174877_v());
    }

    public int func_70297_j_() {
        return 1;
    }

    public int getPlayingIndex() {
        return this.playingIndex;
    }

    public int getTrack() {
        return this.track;
    }

    public boolean setPlayingIndex(int playingIndex, int track) {
        this.playingIndex = playingIndex;
        this.track = track;
        if (this.recalculatePlayingIndex(false)) {
            int tracks = PlayableRecord.getStackTrackCount(this.playingStack);
            if (this.track >= tracks) {
                this.track = 0;
            }
            return true;
        }
        return false;
    }

    public void stopPlaying() {
        this.playingIndex = -1;
        this.track = 0;
        this.playingStack = ItemStack.field_190927_a;
    }

    public void previous() {
        if (this.track > 0) {
            --this.track;
        } else {
            --this.playingIndex;
            if (this.playingIndex < 0) {
                this.playingIndex = this.func_70302_i_() - 1;
            }
            this.nextPlayingIndex(true);
            this.track = Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.func_70302_i_() ? 0 : PlayableRecord.getStackTrackCount(this.func_70301_a(this.playingIndex)) - 1);
            this.playingStack = ItemStack.field_190927_a;
        }
    }

    public void next() {
        int tracks;
        int n = tracks = this.playingIndex < 0 || this.playingIndex >= this.func_70302_i_() ? 1 : PlayableRecord.getStackTrackCount(this.func_70301_a(this.playingIndex));
        if (this.track < tracks - 1) {
            ++this.track;
        } else {
            ++this.playingIndex;
            this.playingIndex %= this.func_70302_i_();
            this.nextPlayingIndex(false);
            this.track = 0;
            this.playingStack = ItemStack.field_190927_a;
        }
    }

    public void nextPlayingIndex(boolean reverse) {
        boolean wrap = false;
        this.playingIndex = MathHelper.func_76125_a((int)this.playingIndex, (int)0, (int)(this.func_70302_i_() - 1));
        while (!PlayableRecord.isPlayableRecord(this.func_70301_a(this.playingIndex))) {
            if (reverse) {
                --this.playingIndex;
                if (this.playingIndex >= 0) continue;
                this.playingIndex = this.func_70302_i_() - 1;
                if (wrap) {
                    this.playingIndex = -1;
                    this.track = 0;
                    this.playingStack = ItemStack.field_190927_a;
                    return;
                }
                wrap = true;
                continue;
            }
            ++this.playingIndex;
            if (this.playingIndex < this.func_70302_i_()) continue;
            this.playingIndex = 0;
            if (wrap) {
                this.playingIndex = -1;
                this.track = 0;
                this.playingStack = ItemStack.field_190927_a;
                return;
            }
            wrap = true;
        }
        this.playingStack = this.func_70301_a(this.playingIndex).func_77946_l();
    }

    public boolean recalculatePlayingIndex(boolean reverse) {
        if (this.func_191420_l()) {
            if (this.playingIndex == -1) {
                return false;
            }
            this.playingIndex = -1;
            this.track = 0;
            return true;
        }
        int oldIndex = this.playingIndex;
        ItemStack oldStack = this.playingStack.func_77946_l();
        this.nextPlayingIndex(reverse);
        if (oldIndex != this.playingIndex || !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)this.playingStack)) {
            this.track = reverse ? Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.func_70302_i_() ? 0 : PlayableRecord.getStackTrackCount(this.func_70301_a(this.playingIndex)) - 1) : 0;
            return true;
        }
        return false;
    }

    public boolean isPlaying() {
        BlockState state = this.func_195044_w();
        return (!state.func_235901_b_((Property)AlbumJukeboxBlock.POWERED) || (Boolean)state.func_177229_b((Property)AlbumJukeboxBlock.POWERED) == false) && !this.func_191420_l();
    }
}

