/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.SampleBuffer;

public class Mp3InputStream
extends InputStream {
    private final InputStream source;
    private final Bitstream stream;
    private final Decoder decoder;
    private final ByteBuffer buffer;
    private SampleBuffer output;
    private AudioFormat format;

    public Mp3InputStream(InputStream source) throws IOException {
        this.source = source;
        this.stream = new Bitstream(source);
        this.decoder = new Decoder();
        this.buffer = ByteBuffer.allocate(4608).order(ByteOrder.LITTLE_ENDIAN);
        if (this.fillBuffer()) {
            throw new IOException("Failed to find header");
        }
    }

    private boolean fillBuffer() throws IOException {
        this.buffer.clear();
        try {
            Obuffer decoderOutput;
            Header header = this.stream.readFrame();
            if (header == null) {
                return true;
            }
            if (this.output == null) {
                int channels = header.mode() == 3 ? 1 : 2;
                this.output = new SampleBuffer(header.sample_frequency(), channels);
                this.decoder.setOutputBuffer(this.output);
                this.format = new AudioFormat(header.frequency(), 16, channels, true, false);
            }
            if ((decoderOutput = this.decoder.decodeFrame(header, this.stream)) != this.output) {
                throw new IOException("Output buffers are different.");
            }
            for (short value : this.output.getBuffer()) {
                this.buffer.putShort(value);
            }
            this.buffer.flip();
        }
        catch (JavaLayerException e) {
            throw new IOException(e);
        }
        this.stream.closeFrame();
        return false;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.fillBuffer()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readAmount;
        int readLength;
        boolean eof = false;
        for (readAmount = 0; readAmount < len && (this.buffer.hasRemaining() || !(eof = this.fillBuffer())); readAmount += readLength) {
            readLength = Math.min(this.buffer.remaining(), len - readAmount);
            this.buffer.get(b, off + readAmount, readLength);
        }
        return eof ? -1 : readAmount;
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        catch (JavaLayerException e) {
            throw new IOException(e);
        }
    }

    public AudioFormat getFormat() {
        return this.format;
    }
}

