/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class TrackData {
    public static final TrackData EMPTY = new TrackData(null, "Unknown", (ITextComponent)new StringTextComponent("Custom Music"));
    public static final Codec<TrackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Url").forGetter(TrackData::getUrl), (App)Codec.STRING.optionalFieldOf("Author", (Object)EMPTY.getArtist()).forGetter(TrackData::getArtist), (App)Codec.STRING.optionalFieldOf("Title", (Object)ITextComponent.Serializer.func_150696_a((ITextComponent)EMPTY.getTitle())).xmap(json -> {
        if (!json.startsWith("{")) {
            return new StringTextComponent(json);
        }
        try {
            return ITextComponent.Serializer.func_240643_a_((String)json);
        }
        catch (JsonParseException e) {
            return new StringTextComponent(json);
        }
    }, ITextComponent.Serializer::func_150696_a).forGetter(TrackData::getTitle)).apply((Applicative)instance, TrackData::new));
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");
    private final String url;
    private final String artist;
    private final ITextComponent title;

    public TrackData(String url, String artist, ITextComponent title) {
        this.url = url;
        this.artist = artist;
        this.title = title;
    }

    public static boolean isValid(CompoundNBT nbt) {
        return nbt.func_150297_b("Url", 8) && TrackData.isValidURL(nbt.func_74779_i("Url"));
    }

    public static boolean isValidURL(@Nullable String url) {
        if (url == null) {
            return false;
        }
        if (TrackData.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(@Nullable String url) {
        if (url == null) {
            return false;
        }
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        if (this.url != null) {
            nbt.func_74778_a("Url", this.url);
        }
        if (this.title != null) {
            nbt.func_74778_a("Title", ITextComponent.Serializer.func_150696_a((ITextComponent)this.title));
        }
        if (this.artist != null) {
            nbt.func_74778_a("Author", this.artist);
        }
        return nbt;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArtist() {
        return this.artist;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public TrackData withUrl(String url) {
        return new TrackData(url, this.artist, this.title);
    }

    public TrackData withArtist(String artist) {
        return new TrackData(this.url, artist, this.title);
    }

    public TrackData withTitle(String title) {
        return new TrackData(this.url, this.artist, (ITextComponent)new StringTextComponent(title));
    }

    public TrackData withTitle(ITextComponent title) {
        return new TrackData(this.url, this.artist, title);
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("sound_source.etched.info", new Object[]{this.artist, this.title});
    }
}

