/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.gui;

import com.anthonyhilyard.equipmentcompare.EquipmentCompare;
import com.anthonyhilyard.equipmentcompare.EquipmentCompareConfig;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ComparisonTooltips {
    private static void drawTooltip(MatrixStack matrixStack, ItemStack itemStack, Rectangle2d rect, List<ITextComponent> tooltipLines, FontRenderer font, Screen screen, int maxWidth, boolean showBadge) {
        int bgColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBackgroundColor.get()).longValue();
        int borderStartColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderStartColor.get()).longValue();
        int borderEndColor = (int)((Long)EquipmentCompareConfig.INSTANCE.badgeBorderEndColor.get()).longValue();
        Style textColor = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)((int)((Long)EquipmentCompareConfig.INSTANCE.badgeTextColor.get()).longValue())));
        IFormattableTextComponent equippedBadge = new StringTextComponent((String)EquipmentCompareConfig.INSTANCE.badgeText.get()).func_240703_c_(textColor);
        GuiUtils.preItemToolTip((ItemStack)itemStack);
        if (showBadge) {
            if (rect.func_199319_b() + rect.func_199317_d() + 4 > screen.field_230709_l_) {
                rect = new Rectangle2d(rect.func_199318_a(), screen.field_230709_l_ - rect.func_199317_d() - 4, rect.func_199316_c(), rect.func_199317_d());
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 401.0);
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            int badgeOffset = 0;
            if (ModList.get().isLoaded("legendarytooltips")) {
                badgeOffset = 6;
                bgColor = -267386864;
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 15 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)rect.func_199318_a(), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c()), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 4 + badgeOffset), (int)bgColor, (int)bgColor);
            } else {
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 15 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)rect.func_199318_a(), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c()), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 1 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 13 + badgeOffset), (int)(rect.func_199318_a() + 2), (int)(rect.func_199319_b() - 3 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + rect.func_199316_c() - 2), (int)(rect.func_199319_b() - 13 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 3 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 14 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 13 + badgeOffset), (int)borderStartColor, (int)borderStartColor);
                GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.func_199318_a() + 1), (int)(rect.func_199319_b() - 3 + badgeOffset), (int)(rect.func_199318_a() + rect.func_199316_c() - 1), (int)(rect.func_199319_b() - 2 + badgeOffset), (int)borderEndColor, (int)borderEndColor);
            }
            font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a((ITextProperties)equippedBadge), (float)rect.func_199318_a() + (float)((rect.func_199316_c() - font.func_238414_a_((ITextProperties)equippedBadge)) / 2), (float)rect.func_199319_b() - 12.0f + (float)badgeOffset, -1, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            renderType.func_228461_a_();
            matrixStack.func_227865_b_();
        }
        Tooltips.renderItemTooltip((ItemStack)itemStack, (MatrixStack)matrixStack, (Tooltips.TooltipInfo)new Tooltips.TooltipInfo(tooltipLines, font), (Rectangle2d)rect, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)-267386864, (int)0x505000FF, (int)1344798847, (boolean)showBadge);
    }

    public static boolean render(MatrixStack matrixStack, int x, int y, Slot hoveredSlot, Minecraft minecraft, FontRenderer font, Screen screen) {
        ItemStack itemStack = hoveredSlot != null ? hoveredSlot.func_75211_c() : ItemStack.field_190927_a;
        return ComparisonTooltips.render(matrixStack, x, y, itemStack, minecraft, font, screen);
    }

    public static boolean render(MatrixStack matrixStack, int x, int y, ItemStack itemStack, Minecraft minecraft, FontRenderer font, Screen screen) {
        if (screen == null) {
            return false;
        }
        if (minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !itemStack.func_190926_b() && !((List)EquipmentCompareConfig.INSTANCE.blacklist.get()).contains(itemStack.func_77973_b().getRegistryName().toString())) {
            EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)itemStack);
            ArrayList<ItemStack> equippedItems = new ArrayList<ItemStack>();
            ItemStack equippedItem = minecraft.field_71439_g.func_184582_a(slot);
            boolean checkItem = true;
            if (slot == EquipmentSlotType.MAINHAND) {
                if (!(itemStack.func_77973_b() instanceof TieredItem) || !(equippedItem.func_77973_b() instanceof TieredItem)) {
                    checkItem = false;
                } else if (((Boolean)EquipmentCompareConfig.INSTANCE.strict.get()).booleanValue() && !itemStack.func_77973_b().getClass().equals(equippedItem.func_77973_b().getClass())) {
                    checkItem = false;
                }
            }
            if (checkItem) {
                equippedItems.add(equippedItem);
                equippedItems.remove(ItemStack.field_190927_a);
                equippedItems.remove(itemStack);
            }
            if (ModList.get().isLoaded("curios")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.CuriosHandler").getMethod("getCuriosMatchingSlot", LivingEntity.class, ItemStack.class).invoke(null, minecraft.field_71439_g, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (ModList.get().isLoaded("baubles")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.BaublesHandler").getMethod("getBaublesMatchingSlot", PlayerEntity.class, ItemStack.class).invoke(null, minecraft.field_71439_g, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            equippedItems.removeIf(stack -> ((List)EquipmentCompareConfig.INSTANCE.blacklist.get()).contains(stack.func_77973_b().getRegistryName().toString()));
            equippedItems.remove(itemStack);
            if (!equippedItems.isEmpty() && EquipmentCompare.tooltipActive ^ (Boolean)EquipmentCompareConfig.INSTANCE.defaultOn.get()) {
                Rectangle2d equippedRect;
                List itemStackTooltipLines;
                Rectangle2d itemStackRect;
                int maxWidth = (screen.field_230708_k_ - equippedItems.size() * 16) / (equippedItems.size() + 1);
                FontRenderer itemFont = itemStack.func_77973_b().getFontRenderer(itemStack);
                if (itemFont == null) {
                    itemFont = font;
                }
                itemStackRect = x + (itemStackRect = Tooltips.calculateRect((ItemStack)itemStack, (MatrixStack)matrixStack, (List)(itemStackTooltipLines = screen.func_231151_a_(itemStack)), (int)x, (int)y, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)maxWidth, (FontRenderer)itemFont)).func_199316_c() + 12 > screen.field_230708_k_ ? new Rectangle2d(screen.field_230708_k_ - itemStackRect.func_199316_c() - 24, itemStackRect.func_199319_b(), itemStackRect.func_199316_c(), itemStackRect.func_199317_d()) : new Rectangle2d(itemStackRect.func_199318_a() - 2, itemStackRect.func_199319_b(), itemStackRect.func_199316_c(), itemStackRect.func_199317_d());
                HashMap<ItemStack, Rectangle2d> tooltipRects = new HashMap<ItemStack, Rectangle2d>();
                HashMap<ItemStack, List> tooltipLines = new HashMap<ItemStack, List>();
                Rectangle2d previousRect = itemStackRect;
                boolean firstRect = true;
                for (ItemStack thisItem : equippedItems) {
                    if (thisItem.func_77973_b().getFontRenderer(thisItem) != null) {
                        itemFont = thisItem.func_77973_b().getFontRenderer(thisItem);
                    }
                    List equippedTooltipLines = screen.func_231151_a_(thisItem);
                    equippedRect = Tooltips.calculateRect((ItemStack)itemStack, (MatrixStack)matrixStack, (List)equippedTooltipLines, (int)(x - previousRect.func_199316_c() - 14), (int)y, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)maxWidth, (FontRenderer)itemFont);
                    StringTextComponent equippedBadge = new StringTextComponent((String)EquipmentCompareConfig.INSTANCE.badgeText.get());
                    int tooltipWidth = equippedRect.func_199316_c();
                    equippedRect = new Rectangle2d(equippedRect.func_199318_a(), equippedRect.func_199319_b(), Math.max(equippedRect.func_199316_c(), itemFont.func_238414_a_((ITextProperties)equippedBadge) + 8), equippedRect.func_199317_d());
                    if (firstRect) {
                        equippedRect = new Rectangle2d(previousRect.func_199318_a() - equippedRect.func_199316_c() - 16 - (equippedRect.func_199316_c() - tooltipWidth) / 2, equippedRect.func_199319_b(), equippedRect.func_199316_c(), equippedRect.func_199317_d());
                        firstRect = false;
                    } else {
                        equippedRect = new Rectangle2d(previousRect.func_199318_a() - equippedRect.func_199316_c() - 4 - (equippedRect.func_199316_c() - tooltipWidth) / 2, equippedRect.func_199319_b(), equippedRect.func_199316_c(), equippedRect.func_199317_d());
                    }
                    tooltipRects.put(thisItem, equippedRect);
                    tooltipLines.put(thisItem, equippedTooltipLines);
                    previousRect = equippedRect;
                }
                int xOffset = -((Rectangle2d)tooltipRects.get(equippedItems.get(equippedItems.size() - 1))).func_199318_a();
                if (xOffset > 0) {
                    for (ItemStack thisItem : equippedItems) {
                        equippedRect = (Rectangle2d)tooltipRects.get(thisItem);
                        tooltipRects.replace(thisItem, new Rectangle2d(equippedRect.func_199318_a() + xOffset, equippedRect.func_199319_b(), equippedRect.func_199316_c(), equippedRect.func_199317_d()));
                    }
                    itemStackRect = new Rectangle2d(itemStackRect.func_199318_a() + xOffset, itemStackRect.func_199319_b(), itemStackRect.func_199316_c(), itemStackRect.func_199317_d());
                }
                for (ItemStack thisItem : equippedItems) {
                    ComparisonTooltips.drawTooltip(matrixStack, thisItem, (Rectangle2d)tooltipRects.get(thisItem), (List)tooltipLines.get(thisItem), font, screen, maxWidth, true);
                }
                ComparisonTooltips.drawTooltip(matrixStack, itemStack, itemStackRect, itemStackTooltipLines, font, screen, maxWidth, false);
                return true;
            }
            return false;
        }
        return false;
    }
}

