/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.tile;

import com.valkyrieofnight.envirocore.core.TierInfo;
import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.ccu.PotEnergyCCUTile;
import com.valkyrieofnight.envirocore.m_comp.m_io.tile.IIOTile;
import com.valkyrieofnight.envirocore.m_comp.m_laser.CLaserModule;
import com.valkyrieofnight.envirocore.m_comp.m_laser.lens.ILaserLensHolderTile;
import com.valkyrieofnight.envirocore.m_comp.m_modifier.CModifiersModule;
import com.valkyrieofnight.envirocore.m_machines.m_mem_progrm.obj.IContainProgramID;
import com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.obj.RGBControllerItem;
import com.valkyrieofnight.envirocore.multiblock.io.IForgeEnergyIO;
import com.valkyrieofnight.envirocore.multiblock.io.IItemIO;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.envirotech.m_voidminer.MVoidMiner;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.program.VoidMinerProgram;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.VoidMinerDataRegistry;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.Drop;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropTarget;
import com.valkyrieofnight.envirotech.m_voidminer.ui.VoidMinerContainer;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IFacing;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IOnPlayerWillDestroy;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.Module;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.BlockPosUtil;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.core.util.scanner.BlockLineScanner;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.multiblock.StructureMap;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VoidMinerCCUTile
extends PotEnergyCCUTile<VoidMinerContainer>
implements IForgeEnergyIO,
IFacing,
IItemIO,
IOnPlayerWillDestroy {
    private static VoidMinerDataRegistry REGISTRY = MVoidMiner.DROP_REGISTRY;
    private Random rand;
    private BlockPos laserTipPos;
    private BlockLineScanner laserBeamScanner;
    private BlockPos lensHolderPosition;
    private Color4 lensColor = Color4.WHITE;
    private VLID focus = null;
    private VLInventory programSlot = new VLInventory(new IOMode[]{IOMode.IN});
    private VLInventory outputSlots = new VLInventory(new IOMode[]{IOMode.OUT});
    private VLID dim;
    private VLID biome;
    private VoidMinerProgram voidMinerProgram;
    private DropList dropList;
    private float lastFocusMultiplier = 1.0f;
    protected TrackerModule tracker;
    private int rftick = 0;
    private BlockPos oldEndPos;

    public VoidMinerContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        ItemStack mhi = playerEntity.func_184614_ca();
        ItemStack ohi = playerEntity.func_184592_cb();
        if (mhi.func_77973_b() instanceof RGBControllerItem || ohi.func_77973_b() instanceof RGBControllerItem) {
            return null;
        }
        if (tileEntity instanceof VoidMinerCCUTile) {
            return new VoidMinerContainer(i, playerEntity.field_71071_by, (VoidMinerCCUTile)tileEntity);
        }
        return null;
    }

    public VoidMinerCCUTile(TileEntityType<?> tileEntityTypeIn, UniPotentialBattery battery) {
        super(tileEntityTypeIn, battery);
        this.laserBeamScanner = new BlockLineScanner(6, this::canBeamPenetrate, this::onBeamUpdate);
        this.modifierHandler.addScannable(CModifiersModule.ENERGY_MULTIPLIER_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.AMPLIFICATION_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.BANDWIDTH_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.FREQUENCY_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.DIMENSIONAL_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.INTERDIMENSIONAL_ATTRIBUTE.getID());
        this.rand = new Random();
        this.setupMainModule();
        this.setupCCUModule((Module.AbstractBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).validSaveDataType(sdt -> true)).canStartProcess(() -> this.isLaserPathValid() && this.inventoryHasSpace() && this.isProgramAndFocusListReady() && this.hasEnoughEnergy(1))).onProcessStarted(() -> ((VoidMinerCCUTile)this).func_70296_d())).checkAndValidateProcessable(subTicks -> this.isLaserPathValid() ? MathUtil.clamp((int)this.getMaxTicksFromEnergy(), (int)0, (int)subTicks) : 0)).canCompleteProcess(() -> this.isLaserPathValid() && this.isProgramAndFocusListReady())).onProcessTick(subTicks -> {
            this.battery.extractPotential(this.getEnergyCost((int)subTicks), false);
            this.func_70296_d();
        })).onComplete(() -> {
            int maxStackSize = CModifiersModule.BANDWIDTH_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Integer.valueOf(1));
            Drop d = this.dropList.getRandom(this.rand);
            ItemStack stack = d.getItem(this.conditionContainerProvider).func_77946_l();
            int stackSize = MathUtil.getRandomRange((Random)this.rand, (int)1, (int)maxStackSize);
            stack.func_190920_e(Math.min(stackSize, 64));
            InventoryUtils.putStackInInventoryAllSlots((IInventory)this.outputSlots, (ItemStack)stack);
        })).maxTickRate(() -> 1)).processDuration(this::getProcessDuration));
    }

    public ConditionContainerProvider getCCP() {
        return this.conditionContainerProvider;
    }

    public boolean canRender() {
        return this.modifierHandler != null;
    }

    public final StructureMap getStructureList() {
        return MVoidMiner.VOID_MINER_MAP;
    }

    public void queueValidOrientations(Queue<XYZOrientation> orientationQueue) {
        orientationQueue.addAll(XYZOrientation.getAllWith((Direction)this.direction, (RelativeDirection)RelativeDirection.FORWARD));
    }

    public void onPlayerWillDestroy(PlayerEntity playerEntity) {
        ItemStack program = this.programSlot.func_70301_a(0);
        if (program != ItemStack.field_190927_a) {
            this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), program));
            this.programSlot.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @NotNull
    public List<XYZOrientation> getValid() {
        return XYZOrientation.getAllWith((Direction)this.direction, (RelativeDirection)RelativeDirection.FORWARD);
    }

    private void findLaserTip() {
        Collection positions = this.scanner.getAllOfType(CLaserModule.FORWARD_LASER_CORE_COMPONENT);
        int furthest = 0;
        for (BlockPos pos : positions) {
            int dist = Math.abs(BlockPosUtil.getDirectionDistance((BlockPos)this.field_174879_c, (BlockPos)pos, (Direction)this.getOrientation().getDirectionFrom(RelativeDirection.FORWARD)));
            if (dist <= furthest) continue;
            furthest = dist;
            this.laserTipPos = pos;
        }
    }

    private void initiateLaserBeamScanner() {
        if (this.laserTipPos == null) {
            return;
        }
        Direction down = this.getOrientation().getDirectionFrom(RelativeDirection.FORWARD);
        this.laserBeamScanner.setup(this.laserTipPos.func_177972_a(down), down, this.getBeamRange(down));
        this.laserBeamScanner.start();
    }

    private void resetMiner() {
        this.dropList = null;
        this.tracker.reset();
    }

    private void updateDropList() {
        if (this.voidMinerProgram == null) {
            this.resetMiner();
            return;
        }
        this.dropList = this.getDropList();
        this.func_70296_d();
    }

    @Nullable
    public DropList getDropList() {
        VLID programID = this.getProgramID();
        if (programID == null) {
            return null;
        }
        return MVoidMiner.DROP_REGISTRY.getDropList(programID, this.getTier().getTier(), this.focus, this.getAmplificationMultiplier(), this.getDropTarget(), this.getDimension(), this.biome);
    }

    private VLID getDimension() {
        return this.dim;
    }

    private DropTarget getDropTarget() {
        Boolean dimMod = (Boolean)CModifiersModule.DIMENSIONAL_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, (Object)false);
        Boolean iDimMod = (Boolean)CModifiersModule.INTERDIMENSIONAL_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, (Object)false);
        if (dimMod.booleanValue() && iDimMod.booleanValue()) {
            return DropTarget.ANY;
        }
        if (dimMod.booleanValue()) {
            return DropTarget.ANY_BIOME;
        }
        if (iDimMod.booleanValue()) {
            return DropTarget.ANY_DIMENSION;
        }
        return DropTarget.NONE;
    }

    private boolean isLaserPathValid() {
        if (this.getBeamEnd() == null) {
            return false;
        }
        BlockPos bep = this.getBeamEnd();
        BlockState bs = this.func_145831_w().func_180495_p(bep);
        return bep.func_177956_o() == 0 || bep.func_177956_o() == this.func_145831_w().func_230315_m_().func_241513_m_() || bs.func_177230_c() == Blocks.field_150357_h;
    }

    private boolean isProgramAndFocusListReady() {
        return this.voidMinerProgram != null && this.dropList != null;
    }

    protected abstract TierInfo getTier();

    public boolean hasLens() {
        return this.focus != null;
    }

    public BlockPos getLensHolderPos() {
        return this.lensHolderPosition;
    }

    public Color4 getLensColor() {
        return this.lensColor;
    }

    public BlockPos getBeamEnd() {
        return this.laserBeamScanner.getEndPos();
    }

    private void checkRequired() {
        boolean programChanged = this.checkProgram();
        boolean focusChanged = this.checkFocusMultiplier();
        boolean lensChanged = this.checkLensHolder();
        if (programChanged || focusChanged || lensChanged) {
            this.updateDropList();
            this.func_70296_d();
        }
    }

    private boolean checkProgram() {
        if (this.updateProgram()) {
            this.resetMiner();
            return true;
        }
        return false;
    }

    private boolean checkLensHolder() {
        if (this.lensHolderPosition != null) {
            if (this.updateFocus()) {
                return true;
            }
        } else {
            this.acquireLensHolderPosition();
        }
        return false;
    }

    private boolean checkFocusMultiplier() {
        float newFocusMultiplier = CModifiersModule.AMPLIFICATION_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Float.valueOf(1.0f)).floatValue();
        if (this.lastFocusMultiplier != newFocusMultiplier) {
            this.lastFocusMultiplier = newFocusMultiplier;
            return true;
        }
        return false;
    }

    private boolean updateFocus() {
        TileEntity tile = this.func_145831_w().func_175625_s(this.lensHolderPosition);
        if (tile instanceof ILaserLensHolderTile) {
            VLID newFocus = ((ILaserLensHolderTile)tile).getFocus();
            if (newFocus != null && !newFocus.equals((Object)this.focus)) {
                this.lensColor = ((ILaserLensHolderTile)tile).getLensColor();
                this.focus = newFocus;
                return true;
            }
            if (newFocus == null && this.focus != null) {
                this.lensColor = Color4.WHITE;
                this.focus = null;
                return true;
            }
        }
        return false;
    }

    private void acquireLensHolderPosition() {
        Collection lensHolders = this.scanner.getAllOfType(CLaserModule.FORWARD_LASER_HOLDER_COMPONENT);
        if (lensHolders.size() > 0) {
            this.lensHolderPosition = (BlockPos)lensHolders.iterator().next();
        }
    }

    protected void serverTickFormed() {
        this.laserBeamScanner.tick();
        if (this.func_145831_w().func_82737_E() % 80L == 0L) {
            this.checkRequired();
        }
        if (this.getProgramTierSettings() != null) {
            this.rftick = (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.getEnergyCost(1));
        }
        super.serverTickFormed();
    }

    protected void serverTickUnformed() {
        super.serverTickUnformed();
        this.rftick = 0;
        this.lensHolderPosition = null;
    }

    public void setFacing(Direction direction) {
        super.setDirection(direction);
        this.func_70296_d();
    }

    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        nbt.func_218657_a("program_slot", (INBT)this.programSlot.serializeNBT());
        if (type != SaveDataType.ITEM) {
            if (this.lensHolderPosition != null) {
                nbt.func_74768_a("lens_x", this.lensHolderPosition.func_177958_n());
                nbt.func_74768_a("lens_y", this.lensHolderPosition.func_177956_o());
                nbt.func_74768_a("lens_z", this.lensHolderPosition.func_177952_p());
            }
            if (this.laserTipPos != null) {
                nbt.func_74768_a("tip_x", this.laserTipPos.func_177958_n());
                nbt.func_74768_a("tip_y", this.laserTipPos.func_177956_o());
                nbt.func_74768_a("tip_z", this.laserTipPos.func_177952_p());
            }
            nbt.func_218657_a("beam", (INBT)this.laserBeamScanner.serializeNBT());
            if (this.lensColor != null) {
                nbt.func_74768_a("lens_color", this.lensColor.getRGBA());
            }
            nbt.func_74768_a("rftick", this.rftick);
            if (this.biome != null) {
                nbt.func_74778_a("biome", this.biome.toString());
            }
            if (this.focus != null) {
                nbt.func_74778_a("focus", this.focus.toString());
            }
            if (this.dim != null) {
                nbt.func_74778_a("dim", this.dim.toString());
            }
        }
        return nbt;
    }

    public void load(CompoundNBT nbt, SaveDataType type) {
        super.load(nbt, type);
        if (nbt.func_74764_b("program_slot")) {
            this.programSlot.deserializeNBT(nbt.func_74775_l("program_slot"));
        }
        if (type != SaveDataType.ITEM) {
            this.lensHolderPosition = nbt.func_74764_b("lens_x") && nbt.func_74764_b("lens_y") && nbt.func_74764_b("lens_z") ? new BlockPos(nbt.func_74762_e("lens_x"), nbt.func_74762_e("lens_y"), nbt.func_74762_e("lens_z")) : null;
            this.laserTipPos = nbt.func_74764_b("tip_x") && nbt.func_74764_b("tip_y") && nbt.func_74764_b("tip_z") ? new BlockPos(nbt.func_74762_e("tip_x"), nbt.func_74762_e("tip_y"), nbt.func_74762_e("tip_z")) : null;
            if (nbt.func_74764_b("beam")) {
                this.laserBeamScanner.deserializeNBT(nbt.func_74775_l("beam"));
            }
            if (nbt.func_74764_b("lens_color")) {
                this.lensColor = new Color4(nbt.func_74762_e("lens_color"));
            }
            this.rftick = nbt.func_74762_e("rftick");
            this.biome = nbt.func_74764_b("biome") ? VLID.from((String)nbt.func_74779_i("biome")) : null;
            this.focus = nbt.func_74764_b("focus") ? VLID.from((String)nbt.func_74779_i("focus")) : null;
            this.dim = nbt.func_74764_b("dim") ? VLID.from((String)nbt.func_74779_i("dim")) : null;
        }
    }

    private void onBeamUpdate(BlockPos newPos) {
        if (this.oldEndPos == null || !this.oldEndPos.equals((Object)newPos)) {
            this.oldEndPos = newPos;
            VLID newBiome = VLID.from((Biome)this.func_145831_w().func_226691_t_(newPos));
            if (this.biome == null || !this.biome.equals((Object)newBiome)) {
                this.biome = newBiome;
                this.updateDropList();
            }
        }
        this.func_70296_d();
    }

    private boolean canBeamPenetrate(BlockPos pos) {
        if (pos.func_177956_o() == 0 || pos.func_177956_o() == this.func_145831_w().func_230315_m_().func_241513_m_()) {
            return false;
        }
        BlockState bs = this.func_145831_w().func_180495_p(pos);
        return bs.func_200131_a((IBlockReader)this.field_145850_b, pos) && bs.func_177230_c() != Blocks.field_150357_h;
    }

    protected abstract int getBeamRange(Direction var1);

    public float getBeamWidthMultiplier() {
        if (this.modifierHandler == null) {
            return 0.0f;
        }
        return CModifiersModule.BANDWIDTH_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Integer.valueOf(0)).intValue();
    }

    public float getFrequencyMultiplier() {
        Object o = this.modifierHandler.getFinalValue(CModifiersModule.FREQUENCY_ATTRIBUTE.getID());
        return o != null ? ((Float)o).floatValue() : 0.0f;
    }

    public float getAmplificationMultiplier() {
        if (this.modifierHandler == null) {
            return 1.0f;
        }
        return CModifiersModule.AMPLIFICATION_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Float.valueOf(1.0f)).floatValue();
    }

    private boolean hasEnoughEnergy(int ticks) {
        return this.battery.getPotentialStored() > this.getEnergyCost(ticks);
    }

    public int getFETickCost() {
        return this.rftick;
    }

    private long getEnergyCost(int ticks) {
        float multiplier = this.getProcessDuration() < this.getMinDuration() ? 2.0f : 1.0f;
        long energy = CModifiersModule.ENERGY_MULTIPLIER_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Long.valueOf(this.getProgramTierSettings().getTickEnergyPotential()));
        return (long)((double)energy * (double)ticks * (double)multiplier);
    }

    private int getMaxTicksFromEnergy() {
        long energy = CModifiersModule.ENERGY_MULTIPLIER_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Long.valueOf(this.getProgramTierSettings().getTickEnergyPotential()));
        int sub = (int)(this.battery.getPotentialStored() / energy);
        return sub;
    }

    @Nullable
    public IInventory getInternalInventory(@NotNull IIOTile iSlave) {
        return iSlave != null ? this.outputSlots : null;
    }

    protected void onMultiblockFormed() {
        this.dim = VLID.from((DimensionType)this.func_145831_w().func_230315_m_());
        super.onMultiblockFormed();
        this.findLaserTip();
        this.initiateLaserBeamScanner();
        this.acquireLensHolderPosition();
        this.checkRequired();
    }

    protected void onMultiblockDeform() {
        super.onMultiblockDeform();
        this.laserBeamScanner.stop();
    }

    private boolean inventoryHasSpace() {
        for (int i = 0; i < this.outputSlots.func_70302_i_(); ++i) {
            if (!this.outputSlots.func_70301_a(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected int getProcessDuration() {
        return MathUtil.clamp((int)CModifiersModule.FREQUENCY_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Integer.valueOf(this.getMaxDuration())), (int)1, (int)this.getMaxDuration());
    }

    protected void onProcessIdleTick() {
    }

    protected final int getMaxDuration() {
        if (this.getProgramTierSettings() == null) {
            return 400;
        }
        return this.getProgramTierSettings().getMaxDuration();
    }

    protected final int getMinDuration() {
        if (this.getProgramTierSettings() == null) {
            return 400;
        }
        return this.getProgramTierSettings().getMinDuration();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IVLInventory getProgramInventory() {
        return this.programSlot;
    }

    public ITextComponent getDisplayName() {
        return this.func_195044_w().func_177230_c().func_235333_g_();
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    public int getDuration() {
        return this.tracker.getCurrentDuration();
    }

    private boolean updateProgram() {
        VLID memeoryProgram = IContainProgramID.getProgram((ItemStack)this.programSlot.func_70301_a(0));
        if (this.voidMinerProgram != null && this.voidMinerProgram.getRecipeID().equals((Object)memeoryProgram)) {
            return false;
        }
        this.voidMinerProgram = MVoidMiner.PROGRAM_REGISTRY.getProgramFromID(memeoryProgram);
        return true;
    }

    @Nullable
    private VoidMinerProgram.MinerSettings getProgramTierSettings() {
        return this.voidMinerProgram != null ? this.voidMinerProgram.getSettings(this.getTier()) : null;
    }

    @Nullable
    private VLID getProgramID() {
        return IContainProgramID.getProgram((ItemStack)this.programSlot.func_70301_a(0));
    }

    @Nullable
    private VoidMinerProgram getProgram() {
        return MVoidMiner.PROGRAM_REGISTRY.getProgramFromID(this.getProgramID());
    }
}

