/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.DropSettings;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.VoidMinerData;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.BiomeList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DimList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.Drop;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropTarget;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.FocusList;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.item.ItemStack;

public class ProgramRegistry {
    public final VLID programID;
    private volatile CopyOnWriteArrayList<Drop> unfocused = Lists.newCopyOnWriteArrayList();
    private volatile ConcurrentMap<VLID, FocusList> focused = Maps.newConcurrentMap();
    private volatile ConcurrentMap<VLID, DimList> dimLists = Maps.newConcurrentMap();
    private volatile ConcurrentMap<VLID, BiomeList> biomeListMap = Maps.newConcurrentMap();

    public ProgramRegistry(VLID id) {
        this.programID = id;
    }

    public void registerData(VLID recipeID, VoidMinerData data) {
        Ingredient<ItemStack> item = data.getItem();
        List<DropSettings> dropSettings = data.getDropSettings();
        for (DropSettings ds : dropSettings) {
            VLID focus = ds.getFocus();
            Drop d = new Drop(recipeID, item, ds.getTiers(), ds.getWeight());
            List<VLID> biomes = ds.getBiomes();
            List<VLID> dims = ds.getDimensions();
            if (ds.isDimensionBlacklist() && ds.isBiomeBlacklist()) {
                d.blacklistDimBiomes(dims, biomes);
                if (focus != null) {
                    this.registerFocused(d, focus);
                    continue;
                }
                this.registerUnfocused(d);
                continue;
            }
            if (ds.isDimensionBlacklist() && !ds.isBiomeBlacklist()) {
                d.blacklistDims(dims);
                if (biomes != null && !biomes.isEmpty()) {
                    this.registerBiomeDrops(d, focus, biomes);
                    continue;
                }
                if (focus != null) {
                    this.registerFocused(d, focus);
                    continue;
                }
                this.registerUnfocused(d);
                continue;
            }
            if (!ds.isDimensionBlacklist() && ds.isBiomeBlacklist()) {
                d.blacklistBiomes(biomes);
                if (dims != null && !dims.isEmpty()) {
                    this.registerDimDrops(d, focus, biomes, dims);
                    continue;
                }
                if (focus != null) {
                    this.registerFocused(d, focus);
                    continue;
                }
                this.registerUnfocused(d);
                continue;
            }
            if (biomes != null && !biomes.isEmpty()) {
                this.registerBiomeDrops(d, focus, biomes);
                continue;
            }
            if (dims != null && !dims.isEmpty()) {
                this.registerDimDrops(d, focus, biomes, dims);
                continue;
            }
            if (focus != null) {
                this.registerFocused(d, focus);
                continue;
            }
            this.registerUnfocused(d);
        }
    }

    protected void registerBiomeDrops(Drop d, VLID focus, List<VLID> biomes) {
        for (VLID biome : biomes) {
            this.biomeListMap.computeIfAbsent(biome, bid -> new BiomeList((VLID)bid));
            this.biomeListMap.computeIfPresent(biome, (bid, biomeList) -> {
                biomeList.register(d, focus);
                return biomeList;
            });
        }
    }

    protected void registerDimDrops(Drop d, VLID focus, List<VLID> biomes, List<VLID> dims) {
        for (VLID dim : dims) {
            this.dimLists.computeIfAbsent(dim, did -> new DimList((VLID)did));
            this.dimLists.computeIfPresent(dim, (vlid, dimList) -> {
                dimList.register(d, biomes, focus);
                return dimList;
            });
        }
    }

    protected void registerFocused(Drop d, VLID focus) {
        this.focused.computeIfAbsent(focus, fid -> new FocusList((VLID)fid));
        this.focused.computeIfPresent(focus, (fid, focusList) -> {
            focusList.register(d);
            return focusList;
        });
    }

    protected void registerUnfocused(Drop d) {
        this.unfocused.add(d);
    }

    public DropList getFocusedList(int tier, @Nullable VLID focus, float focusWeightMultiplier, DropTarget dropTarget, @Nullable VLID dim, @Nullable VLID biome) {
        HashMap drops = Maps.newHashMap();
        if (biome != null && this.biomeListMap.containsKey(biome) && !dropTarget.isAnyBiome()) {
            ((BiomeList)this.biomeListMap.get(biome)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        } else if (dropTarget.isAnyBiome()) {
            for (BiomeList bl : this.biomeListMap.values()) {
                bl.addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
            }
        }
        if (dim != null && this.dimLists.containsKey(dim) && !dropTarget.isAnyDim()) {
            ((DimList)this.dimLists.get(dim)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        } else if (dropTarget.isAnyDim()) {
            for (DimList dl : this.dimLists.values()) {
                dl.addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
            }
        }
        if (focus != null && this.focused.containsKey(focus)) {
            ((FocusList)this.focused.get(focus)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        }
        for (Drop d : this.unfocused) {
            if (!d.isValid() || !d.tiers.contains(tier) || !ProgramRegistry.canAddDrop(d, dropTarget, dim, biome)) continue;
            drops.putIfAbsent(d.recipeID, d);
        }
        ArrayList dropList = Lists.newArrayList();
        dropList.addAll(drops.values());
        if (dropList.isEmpty()) {
            return null;
        }
        return new DropList(dropList);
    }

    protected static boolean canAddDrop(Drop d, DropTarget target, VLID dim, VLID biome) {
        switch (target) {
            case ANY: {
                return true;
            }
            case ANY_BIOME: {
                return !d.isBlacklistedBiome(biome);
            }
            case ANY_DIMENSION: {
                return !d.isBlacklistedDim(dim);
            }
        }
        return !d.isBlacklistedDimOrBiome(dim, biome);
    }
}

