/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.DropSettings;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.VoidMinerData;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.VoidMinerDataRegistry;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.item.ItemStack;

public class VoidMinerDataDeserializer
extends VLRecipeSerializer<VoidMinerData, VoidMinerDataRegistry> {
    protected static final VLID MULTI_MINER = new VLID("envirotech", "multi");

    public VoidMinerDataDeserializer(VoidMinerDataRegistry registry) {
        super((VLRecipeRegistry)registry);
    }

    public VoidMinerData deserializeRecipe(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo;
        if (json == null) {
            return null;
        }
        if (json.isJsonObject() && (jo = (JsonObject)json).has("item") && jo.has("config")) {
            CopyOnWriteArrayList programs = Lists.newCopyOnWriteArrayList();
            if (jo.has("programs")) {
                JsonArray proga = JsonUtils.getAsArray((JsonObject)jo, (String)"programs");
                if (proga == null || proga.isJsonNull()) {
                    throw new JsonParseException("VoidMinerDrop field: program is null or empty please fix");
                }
                for (int i = 0; i < proga.size(); ++i) {
                    String s = JsonUtils.getAsString((JsonElement)proga.get(i));
                    if (StringUtils.isNullOrEmpty((CharSequence)s)) {
                        throw new JsonParseException("VoidMinerDrop field: program is null or empty please fix");
                    }
                    VLID id = VLID.from((String)s);
                    if (id == null) continue;
                    programs.add(id);
                }
            } else if (jo.has("program")) {
                String program = JsonUtils.getAsString((JsonObject)jo, (String)"program");
                if (StringUtils.isNullOrEmpty((CharSequence)program)) {
                    throw new JsonParseException("VoidMinerDrop field: program is null or empty please fix");
                }
                programs.add(VLID.from((String)program));
            } else {
                return null;
            }
            if (!programs.contains(MULTI_MINER)) {
                programs.add(MULTI_MINER);
            }
            Ingredient drop = DeserializerUtils.getRawItemIngredient((JsonObject)JsonUtils.getAsJsonObject((JsonObject)jo, (String)"item"), (JsonDeserializationContext)context);
            CopyOnWriteArrayList settings = Lists.newCopyOnWriteArrayList();
            JsonElement cfgo = jo.get("config");
            if (cfgo.isJsonArray()) {
                JsonArray cfg = (JsonArray)cfgo;
                for (int i = 0; i < cfg.size(); ++i) {
                    DropSettings ds = this.deserializeDropSettings(cfg.get(i));
                    if (ds == null) continue;
                    settings.add(ds);
                }
            }
            if (drop == null) {
                throw new JsonParseException("VoidMinerDrop field (item) is invalid please fix");
            }
            if (settings == null || settings.isEmpty()) {
                throw new JsonParseException("VoidMinerDrop field (configs) is empty of invalid please fix");
            }
            return new VoidMinerData(programs, (Ingredient<ItemStack>)drop, (CopyOnWriteArrayList<DropSettings>)settings);
        }
        return null;
    }

    protected VoidMinerData createBlankDisableRecipe() {
        return new VoidMinerData(Lists.newCopyOnWriteArrayList(), null, null);
    }

    private DropSettings deserializeDropSettings(JsonElement je) {
        JsonObject jo;
        if (je.isJsonObject() && (jo = (JsonObject)je).has("weight")) {
            JsonElement te;
            JsonElement de;
            JsonElement be;
            String focus = JsonUtils.getAsString((JsonObject)jo, (String)"focus");
            int weight = JsonUtils.getAsInt((JsonObject)jo, (String)"weight");
            boolean biomeBlacklist = JsonUtils.getAsBooleanOrDefault((JsonObject)jo, (String)"blacklist_biomes", (boolean)false);
            CopyOnWriteArrayList biomes = Lists.newCopyOnWriteArrayList();
            if (jo.has("biomes") && (be = jo.get("biomes")).isJsonArray()) {
                JsonArray ja = be.getAsJsonArray();
                for (int i = 0; i < ja.size(); ++i) {
                    String s = JsonUtils.getAsString((JsonElement)ja.get(i));
                    if (StringUtils.isNullOrEmpty((CharSequence)s)) continue;
                    biomes.add(VLID.from((String)s));
                }
            }
            boolean dimBlacklist = JsonUtils.getAsBooleanOrDefault((JsonObject)jo, (String)"blacklist_dimensions", (boolean)false);
            CopyOnWriteArrayList dims = Lists.newCopyOnWriteArrayList();
            if (jo.has("dimensions") && (de = jo.get("dimensions")).isJsonArray()) {
                JsonArray ja = de.getAsJsonArray();
                for (int i = 0; i < ja.size(); ++i) {
                    String s = JsonUtils.getAsString((JsonElement)ja.get(i));
                    if (StringUtils.isNullOrEmpty((CharSequence)s)) continue;
                    dims.add(VLID.from((String)s));
                }
            }
            ArrayList tiers = Lists.newArrayList();
            if (jo.has("tiers") && (te = jo.get("tiers")).isJsonArray()) {
                JsonArray ja = te.getAsJsonArray();
                for (int i = 0; i < ja.size(); ++i) {
                    int tier = JsonUtils.getAsIntOrDefault((JsonElement)ja.get(i), (int)-1);
                    if (tier <= 0) continue;
                    tiers.add(tier);
                }
            }
            if (tiers.isEmpty()) {
                for (int i = 0; i < 8; ++i) {
                    tiers.add(i + 1);
                }
            }
            return new DropSettings(StringUtils.isNullOrEmpty((CharSequence)focus) ? null : VLID.from((String)focus), dimBlacklist, dims, biomeBlacklist, biomes, tiers, weight);
        }
        return null;
    }

    protected void handleException(VLID vlid, Exception e) {
        e.printStackTrace();
    }
}

