/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.program;

import com.valkyrieofnight.envirocore.core.TierInfo;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.core.network.IWritePacketData;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import net.minecraft.network.PacketBuffer;

public class VoidMinerProgram
extends VLRecipe {
    private MinerSettings litherite;
    private MinerSettings erodium;
    private MinerSettings kyronite;
    private MinerSettings pladium;
    private MinerSettings ionite;
    private MinerSettings aethium;
    private MinerSettings nanorite;
    private MinerSettings xerothium;
    private MinerSettings[] settings;

    public VoidMinerProgram(@NotNull MinerSettings litherite, @NotNull MinerSettings erodium, @NotNull MinerSettings kyronite, @NotNull MinerSettings pladium, @NotNull MinerSettings ionite, @NotNull MinerSettings aethium, @NotNull MinerSettings nanorite, @NotNull MinerSettings xerothium) {
        this.litherite = litherite;
        this.erodium = erodium;
        this.kyronite = kyronite;
        this.pladium = pladium;
        this.ionite = ionite;
        this.aethium = aethium;
        this.nanorite = nanorite;
        this.xerothium = xerothium;
        this.settings = new MinerSettings[]{this.litherite, this.erodium, this.kyronite, this.pladium, this.ionite, this.aethium, this.nanorite, this.xerothium};
    }

    public VoidMinerProgram(PacketBuffer buffer) {
        super(buffer);
    }

    public MinerSettings getSettings(@NotNull TierInfo tier) {
        return this.settings[(tier.getTier() - 1) % this.settings.length];
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        this.litherite.writePacketData(packetBuffer);
        this.erodium.writePacketData(packetBuffer);
        this.kyronite.writePacketData(packetBuffer);
        this.pladium.writePacketData(packetBuffer);
        this.ionite.writePacketData(packetBuffer);
        this.aethium.writePacketData(packetBuffer);
        this.nanorite.writePacketData(packetBuffer);
        this.xerothium.writePacketData(packetBuffer);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        this.litherite = new MinerSettings(packetBuffer);
        this.erodium = new MinerSettings(packetBuffer);
        this.kyronite = new MinerSettings(packetBuffer);
        this.pladium = new MinerSettings(packetBuffer);
        this.ionite = new MinerSettings(packetBuffer);
        this.aethium = new MinerSettings(packetBuffer);
        this.nanorite = new MinerSettings(packetBuffer);
        this.xerothium = new MinerSettings(packetBuffer);
        this.settings = new MinerSettings[]{this.litherite, this.erodium, this.kyronite, this.pladium, this.ionite, this.aethium, this.nanorite, this.xerothium};
    }

    protected boolean canWriteData() {
        return this.litherite != null && this.erodium != null && this.kyronite != null && this.pladium != null && this.ionite != null && this.aethium != null && this.nanorite != null && this.xerothium != null;
    }

    public static class MinerSettings
    implements IWritePacketData {
        private int minDuration;
        private int maxDuration;
        private int tickEnergy;
        private boolean enabled;

        public MinerSettings(boolean enabled, int minDuration, int maxDuration, int tickEnergy) {
            this.enabled = enabled;
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
            this.tickEnergy = MathUtil.clamp((int)tickEnergy, (int)0, (int)Integer.MAX_VALUE);
        }

        public MinerSettings(PacketBuffer buffer) {
            this.readPacketData(buffer);
        }

        boolean isEnabled() {
            return this.enabled;
        }

        public int getMinDuration() {
            return this.minDuration;
        }

        public int getMaxDuration() {
            return this.maxDuration;
        }

        public long getTickEnergyPotential() {
            return EnergyUtil.getForgeEnergyConverter().convertToPotential((Number)this.tickEnergy);
        }

        public void writePacketData(PacketBuffer packetBuffer) {
            packetBuffer.writeBoolean(this.enabled);
            packetBuffer.writeInt(this.minDuration);
            packetBuffer.writeInt(this.maxDuration);
            packetBuffer.writeInt(this.tickEnergy);
        }

        public void readPacketData(PacketBuffer packetBuffer) {
            this.enabled = packetBuffer.readBoolean();
            this.minDuration = packetBuffer.readInt();
            this.maxDuration = packetBuffer.readInt();
            this.tickEnergy = packetBuffer.readInt();
        }
    }
}

