/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.jei.categories;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.envirotech.jei.EnviroTechJEIPlugin;
import com.valkyrieofnight.envirotech.m_voidminer.MVoidMiner;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.VoidMinerData;
import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;

public class VoidMinerCategory
implements IRecipeCategory<VoidMinerData> {
    public static final VLID ID = VLID.from((String)"envirotech", (String)"void_miner");
    private final String localized;
    private final IDrawable icon;
    private final IDrawable bg;
    private final IDrawable biomesIcon;
    private final IDrawable dimsIcon;
    private final ConditionContainerProvider cdp;
    private final String focus;
    private final String localBiomesWhitelist;
    private final String localBiomesBlacklist;
    private final String localDimsWhitelist;
    private final String localDimsBlacklist;

    public VoidMinerCategory(IJeiHelpers jeiHelpers) {
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.localized = LangUtil.toLoc((String)"label.envirotech.void_miner");
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)MVoidMiner.XEROTHIUM_VOID_MINER_CCU));
        this.bg = guiHelper.createBlankDrawable(160, 80);
        this.cdp = ConditionDataContainerHandler.getInstance().getProvider(this::getDim, this::getPlayerID);
        this.biomesIcon = guiHelper.createDrawable((ResourceLocation)EnviroTechJEIPlugin.ICONS, 0, 0, 25, 35);
        this.dimsIcon = guiHelper.createDrawable((ResourceLocation)EnviroTechJEIPlugin.ICONS, 25, 0, 25, 35);
        this.focus = LangUtil.toLoc((String)"tooltip.envirocore.focus");
        this.localBiomesWhitelist = LangUtil.toLoc((String)"label.envirotech.biome_whitelist");
        this.localBiomesBlacklist = LangUtil.toLoc((String)"label.envirotech.biome_blacklist");
        this.localDimsWhitelist = LangUtil.toLoc((String)"label.envirotech.dim_whitelist");
        this.localDimsBlacklist = LangUtil.toLoc((String)"label.envirotech.dim_blacklist");
    }

    private PlayerID getPlayerID() {
        GameProfile gp = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
        return new PlayerID(gp.getId(), gp.getName());
    }

    private DimensionType getDim() {
        return Minecraft.func_71410_x().field_71441_e.func_230315_m_();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends VoidMinerData> getRecipeClass() {
        return VoidMinerData.class;
    }

    public String getTitle() {
        return this.localized;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(VoidMinerData voidMinerData, IIngredients iIngredients) {
        iIngredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(voidMinerData.getItem().request(this.cdp)));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, VoidMinerData voidMinerData, IIngredients iIngredients) {
        IGuiItemStackGroup isg = iRecipeLayout.getItemStacks();
        isg.init(0, false, 10, 10);
        isg.set(iIngredients);
    }

    public void draw(VoidMinerData recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.0f);
        matrixStack.func_227861_a_(60.0, 10.0, 0.0);
        this.dimsIcon.draw(matrixStack);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.0f);
        matrixStack.func_227861_a_(60.0, 10.0, 0.0);
        this.biomesIcon.draw(matrixStack);
        matrixStack.func_227865_b_();
    }
}

