/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergy.m_thermal.datapack.fluidheat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.enviroenergy.m_thermal.datapack.fluidheat.FluidTemp;
import com.valkyrieofnight.enviroenergy.m_thermal.datapack.fluidheat.FluidTempRegistry;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeSerializer;
import java.lang.reflect.Type;
import net.minecraftforge.fluids.FluidStack;

public class FluidTempDeserializer
extends VLRecipeSerializer<FluidTemp, FluidTempRegistry> {
    public FluidTempDeserializer(FluidTempRegistry registry) {
        super((VLRecipeRegistry)registry);
    }

    public FluidTemp deserializeRecipe(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jo;
        if (jsonElement.isJsonObject() && (jo = jsonElement.getAsJsonObject()).has("fluid") && jo.has("temp")) {
            Ingredient fluid = DeserializerUtils.getRawFluidIngredient((JsonObject)jo, (JsonDeserializationContext)jsonDeserializationContext);
            int temp = JsonUtils.getAsIntOrDefault((JsonObject)jo, (String)"temp", (int)-1);
            if (temp > -1 && fluid != null) {
                return new FluidTemp((Ingredient<FluidStack>)fluid, temp);
            }
        }
        return null;
    }

    protected FluidTemp createBlankDisableRecipe() {
        return new FluidTemp(null, 0);
    }

    protected void handleException(VLID vlid, Exception e) {
    }
}

