/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.util;

import com.valkyrieofnight.enviroenergyapi.api.storage.IEEStorage;
import com.valkyrieofnight.enviroenergyapi.api.tile.IEEProvider;
import com.valkyrieofnight.enviroenergyapi.api.tile.IEEReceiver;
import com.valkyrieofnight.enviroenergyapi.util.NumberEnergyConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class EnergyUtil {
    public static final NumberEnergyConverter<Integer> FE_CONVERTER = new NumberEnergyConverter<Integer>(10){

        @Override
        public Integer convertFromPotential(long potential) {
            return (int)Math.min(this.getMaximumConvertable(potential) / (long)this.nativeVoltage, Integer.MAX_VALUE);
        }
    };
    public static final NumberEnergyConverter<Integer> RF_CONVERTER = new NumberEnergyConverter<Integer>(10){

        @Override
        public Integer convertFromPotential(long potential) {
            return (int)Math.min(this.getMaximumConvertable(potential) / (long)this.nativeVoltage, Integer.MAX_VALUE);
        }
    };
    public static final NumberEnergyConverter<Integer> EU_CONVERTER = new NumberEnergyConverter<Integer>(20){

        @Override
        public Integer convertFromPotential(long potential) {
            return (int)Math.min(this.getMaximumConvertable(potential) / (long)this.nativeVoltage, Integer.MAX_VALUE);
        }
    };
    public static final NumberEnergyConverter<Double> MJ_CONVERTER = new NumberEnergyConverter<Double>(50){

        @Override
        public Double convertFromPotential(long potential) {
            return this.getMaximumConvertable(potential) / (long)this.nativeVoltage;
        }
    };
    public static final NumberEnergyConverter<Double> JOULES_CONVERTER = new NumberEnergyConverter<Double>(2){

        @Override
        public Double convertFromPotential(long potential) {
            return this.getMaximumConvertable(potential) / (long)this.nativeVoltage;
        }
    };

    public static void outputEnergy(TileEntity fromTile, IEEStorage fromStorage, Direction ... toDirections) {
        for (Direction d : toDirections) {
            Direction fromDirection;
            IEEReceiver receiver;
            TileEntity te = fromTile.func_145831_w().func_175625_s(fromTile.func_174877_v().func_177972_a(d));
            if (!(te instanceof IEEReceiver) || (receiver = (IEEReceiver)te).getReceiveVoltage(fromDirection = d.func_176734_d()) != fromStorage.getExtractVoltage() || !receiver.canConnect(fromDirection)) continue;
            fromStorage.extractEnergy(receiver.receiveEnergy(fromDirection, fromStorage.extractEnergy(receiver.getMaxReceive(fromDirection), true), false), false);
        }
    }

    public static void outputEnergy(TileEntity fromTile, IEEProvider fromProvider, Direction ... toDirections) {
        for (Direction d : toDirections) {
            Direction fromDirection;
            IEEReceiver receiver;
            TileEntity te = fromTile.func_145831_w().func_175625_s(fromTile.func_174877_v().func_177972_a(d));
            if (!(te instanceof IEEReceiver) || (receiver = (IEEReceiver)te).getReceiveVoltage(fromDirection = d.func_176734_d()) != fromProvider.getExtractVoltage(fromDirection) || !receiver.canConnect(fromDirection)) continue;
            fromProvider.extractEnergy(d, receiver.receiveEnergy(fromDirection, fromProvider.extractEnergy(d, receiver.getMaxReceive(fromDirection), true), false), false);
        }
    }

    public static NumberEnergyConverter<Integer> getForgeEnergyConverter() {
        return FE_CONVERTER;
    }

    public static NumberEnergyConverter<Integer> getRedstoneFluxConverter() {
        return RF_CONVERTER;
    }

    public static NumberEnergyConverter<Integer> getIndustrialCraftEUConverter() {
        return EU_CONVERTER;
    }

    public static NumberEnergyConverter<Double> getBuildcraftMJConverter() {
        return MJ_CONVERTER;
    }

    public static NumberEnergyConverter<Double> getMekanismJoulesConverter() {
        return JOULES_CONVERTER;
    }
}

