/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.api.storage;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.INBTSerializable;
import com.valkyrieofnight.enviroenergyapi.api.VoltageRange;
import javax.annotation.Nonnull;

public interface IEEStorage
extends INBTSerializable {
    public Energy extractEnergy(@Nonnull Energy var1, boolean var2);

    default public Energy getMaxExtract() {
        return new Energy(this.getExtractVoltage(), this.getCurrentStored());
    }

    public int getExtractVoltage();

    default public VoltageRange getExtractVoltageRange() {
        return VoltageRange.fromVoltage(this.getExtractVoltage());
    }

    public Energy receiveEnergy(@Nonnull Energy var1, boolean var2);

    default public Energy getMaxReceive() {
        return new Energy(this.getReceiveVoltage(), this.getCurrentCapacity());
    }

    public int getReceiveVoltage();

    default public VoltageRange getReceiveVoltageRange() {
        return VoltageRange.fromVoltage(this.getReceiveVoltage());
    }

    public int getCurrentStored();

    public int getCurrentCapacity();

    default public int getCurrentRoom() {
        return this.getCurrentCapacity() - this.getCurrentStored();
    }

    default public float getStoredScaled() {
        return (float)this.getCurrentStored() / (float)this.getCurrentCapacity();
    }
}

