/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.obj;

import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.core.block.EColoredSlaveBlock;
import com.valkyrieofnight.envirocore.m_tools.m_rgb_controller.ui.RGBControllerContainer;
import com.valkyrieofnight.vlib.core.obj.item.VLItem;
import com.valkyrieofnight.vlib.core.obj.item.base.ItemProps;
import com.valkyrieofnight.vlib.core.obj.item.base.color.IColorProviderItem;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorableTile;
import com.valkyrieofnight.vlib.core.util.NetworkUtils;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.color.ColorUtil;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RGBControllerItem
extends VLItem
implements IColorProviderItem {
    public Color4 defaultC0 = Color4.CYAN;
    public Color4 defaultC1 = Color4.BLACK;
    private static final String COLORS = "colors";

    public RGBControllerItem() {
        super(new VLID("envirocore", "rgb_controller"), new ItemProps().rarity(Rarity.EPIC).tab((ItemGroup)EnviroCore.TOOLS).maxStackSize(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        QuickTooltips.createConditional((Supplier)QuickTooltips.SHIFT).addFalse(new ITextComponent[]{QuickTooltips.shiftForInfoTooltip()}).addTrue(new ITextComponent[]{new TranslationTextComponent("info.envirocore.rgb_controller.one").func_230530_a_(StyleUtil.create((Color4)Color4.SILVER))}).addTrue(new ITextComponent[]{new TranslationTextComponent("info.envirocore.rgb_controller.two").func_230530_a_(StyleUtil.create((Color4)Color4.SILVER))}).buildTo(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity te;
        BlockState bs = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (bs.func_235901_b_((Property)EColoredSlaveBlock.LIGHT_LEVEL)) {
            if (context.func_195999_j().func_213453_ef()) {
                this.setLightLevel(context.func_195996_i(), (Integer)bs.func_177229_b((Property)EColoredSlaveBlock.LIGHT_LEVEL));
            } else {
                context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)bs.func_206870_a((Property)EColoredSlaveBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(MathUtil.clamp((int)this.getLightLevel(context.func_195996_i()), (int)0, (int)15))));
            }
        }
        if ((te = context.func_195991_k().func_175625_s(context.func_195995_a())) instanceof IColorableTile) {
            IColorableTile tc = (IColorableTile)te;
            ItemStack tool = context.func_195999_j().func_184586_b(context.func_221531_n());
            if (tool.func_77973_b() == this) {
                boolean flag;
                if (context.func_195999_j().func_213453_ef()) {
                    flag = this.getAndSaveColors(tool, tc);
                } else {
                    flag = this.paintWithSavedColors(tool, tc);
                    context.func_195991_k().func_184138_a(context.func_195995_a(), te.func_195044_w(), te.func_195044_w(), 0);
                }
                if (flag) {
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        NetworkUtils.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (Item)this, (wid, pinv, cont) -> new RGBControllerContainer((int)wid, (PlayerInventory)pinv), packetBuffer -> {});
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    protected boolean paintWithSavedColors(ItemStack stack, IColorableTile ct) {
        int[] chans;
        CompoundNBT colors = stack.func_190925_c(COLORS);
        boolean flag = false;
        for (int c : chans = ct.getAllColorChannels()) {
            if (!colors.func_74764_b("" + c)) continue;
            int color = colors.func_74762_e("" + c);
            flag = true;
            ct.setColor(c, color);
        }
        return flag;
    }

    protected boolean getAndSaveColors(ItemStack stack, IColorableTile ct) {
        CompoundNBT colors = stack.func_190925_c(COLORS);
        int[] chans = ct.getAllColorChannels();
        boolean did = false;
        for (int c : chans) {
            int color = ct.getColor(c);
            colors.func_74768_a("" + c, color);
            did = true;
        }
        return did;
    }

    public void setSettings(ItemStack stack, int primary, int secondary, int light) {
        CompoundNBT colors = stack.func_190925_c(COLORS);
        colors.func_74768_a("0", primary);
        colors.func_74768_a("1", secondary);
        colors.func_74768_a("light_level", light);
        stack.func_77983_a(COLORS, (INBT)colors);
    }

    public void setColor(ItemStack stack, String channel, int color) {
        CompoundNBT colors = stack.func_190925_c(COLORS);
        colors.func_74768_a(channel, color);
        stack.func_77983_a(COLORS, (INBT)colors);
    }

    public int getPrimaryColor(ItemStack stack) {
        return this.getColor(stack, 0);
    }

    public int getLightLevel(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b(COLORS) && stack.func_196082_o().func_74775_l(COLORS).func_74764_b("light_level")) {
            return stack.func_196082_o().func_74775_l(COLORS).func_74762_e("light_level");
        }
        return 0;
    }

    public void setLightLevel(ItemStack stack, int light) {
        CompoundNBT colors = stack.func_190925_c(COLORS);
        colors.func_74768_a("light_level", light);
        stack.func_77983_a(COLORS, (INBT)colors);
    }

    public int getSecondaryColor(ItemStack stack) {
        return this.getColor(stack, 1);
    }

    public int getColor(ItemStack itemStack, int i) {
        CompoundNBT colors;
        CompoundNBT nbt = itemStack.func_196082_o();
        if (!nbt.func_74764_b(COLORS)) {
            colors = new CompoundNBT();
            nbt.func_218657_a(COLORS, (INBT)colors);
        } else {
            colors = nbt.func_74775_l(COLORS);
        }
        itemStack.func_77982_d(nbt);
        switch (i) {
            case 0: {
                return colors.func_74764_b("0") ? colors.func_74762_e("0") : this.defaultC0.getRGBA();
            }
            case 1: {
                return colors.func_74764_b("1") ? colors.func_74762_e("1") : this.defaultC1.getRGBA();
            }
        }
        return ColorUtil.MC_WHITE;
    }

    public int[] getAllColorChannels() {
        return new int[]{0, 1};
    }
}

