/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_crystalizer.obj;

import com.valkyrieofnight.envirocore.core.tile.machine.ECEnergyReceiverTile;
import com.valkyrieofnight.envirocore.m_machines.m_crystalizer.MCrystallizerModule;
import com.valkyrieofnight.envirocore.m_machines.m_crystalizer.datapack.CrystallizerRecipe;
import com.valkyrieofnight.envirocore.m_machines.m_crystalizer.ui.CrystallizerContainer;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.VoltageRange;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.integration.forge.fluid.IVLFluidTank;
import com.valkyrieofnight.vlib.integration.forge.fluid.VLFluidTank;
import com.valkyrieofnight.vlib.integration.forge.fluid.tile.FluidIOHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrystallizerTile
extends ECEnergyReceiverTile
implements IProvideGui<CrystallizerContainer> {
    protected static long POTENTIAL_PER_TICK = 1000L;
    protected static int VOLTAGE = VoltageRange.EXTRA_LOW.getMaxVoltage();
    protected VLFluidTank fluidTank;
    protected VLInventory fluidIO;
    protected VLInventory inputInventory;
    protected VLInventory outputInventory;
    protected FluidIOHandler fluidIOHandler;
    protected CrystallizerRecipe recipe;
    protected ItemStack result = ItemStack.field_190927_a;
    protected TrackerModule tracker;

    public CrystallizerContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        if (tileEntity instanceof CrystallizerTile) {
            return new CrystallizerContainer(i, playerEntity.field_71071_by, (CrystallizerTile)tileEntity);
        }
        return null;
    }

    public CrystallizerTile() {
        super(MCrystallizerModule.TILE, VOLTAGE, VOLTAGE * 100000);
        this.fluidTank = new VLFluidTank(4000);
        this.fluidTank.setValidator(this::isValidFluid);
        this.fluidIO = new VLInventory(new IOMode[]{IOMode.IN, IOMode.OUT});
        this.inputInventory = new VLInventory(new IOMode[]{IOMode.IN, IOMode.IN, IOMode.IN});
        this.outputInventory = new VLInventory(new IOMode[]{IOMode.OUT});
        this.fluidIOHandler = new FluidIOHandler((IInventory)this.fluidIO, EnumIO.INPUT, (IVLFluidTank)this.fluidTank, () -> ((CrystallizerTile)this).func_70296_d());
        this.setupInventory(new RelativeDirection[]{RelativeDirection.FORWARD}, new IVLSerializableInventory[]{this.fluidIO, this.inputInventory, this.outputInventory});
        this.setupMainModule(ModuleBuilders.noAcceleration().addModule((IModuleBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).canStartProcess(this::canStartProcess)).checkAndValidateProcessable(this::checkAndValidateProcessable)).canCompleteProcess(this::canCompleteProcess)).onProcessTick(this::onProcessTicks)).onComplete(this::onCompleteProcess)).maxTickRate(() -> 4)).processDuration(this::getProcessDuration)).serverTick(() -> ((FluidIOHandler)this.fluidIOHandler).tick())));
    }

    protected void resetTracker() {
        this.tracker.reset();
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    public ItemStack getMainResult() {
        return this.result;
    }

    public VLFluidTank getFluidTank() {
        return this.fluidTank;
    }

    protected boolean isValidFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        nbt.func_218657_a("tank", (INBT)this.fluidTank.serializeNBT());
        if (type == SaveDataType.TO_CLIENT) {
            CompoundNBT output = new CompoundNBT();
            this.result.func_77982_d(output);
            nbt.func_218657_a("result", (INBT)output);
        }
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("tank")) {
            this.fluidTank.deserializeNBT(nbt.func_74775_l("tank"));
        }
        if (nbt.func_74764_b("result")) {
            this.result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result"));
        }
        super.load(nbt, type);
    }

    protected boolean canStartProcess() {
        if (this.recipe == null || !this.isRecipeValid()) {
            this.recipe = MCrystallizerModule.RECIPE_REGISTRY.getRecipe(this.conditionProvider, this.inputInventory.func_70301_a(0), this.inputInventory.func_70301_a(1), this.inputInventory.func_70301_a(2), this.fluidTank.getFluid());
        }
        if (this.recipe != null) {
            return this.isRecipeValid() && InventoryUtils.canInsertAll((IInventory)this.outputInventory, (int)0, (ItemStack)this.recipe.getOutput(this.conditionProvider));
        }
        return false;
    }

    private boolean isRecipeValid() {
        return this.recipe.testInput(this.conditionProvider, this.inputInventory.func_70301_a(0), this.inputInventory.func_70301_a(1), this.inputInventory.func_70301_a(2), this.fluidTank.getFluid());
    }

    protected int checkAndValidateProcessable(int i) {
        if (this.recipe == null || !this.isRecipeValid()) {
            this.resetTracker();
        }
        if (this.energyStorage.getPotentialStored() >= POTENTIAL_PER_TICK * (long)i) {
            return i;
        }
        return 0;
    }

    protected boolean canCompleteProcess() {
        if (this.recipe == null || !this.isRecipeValid()) {
            this.resetTracker();
            return false;
        }
        if (this.outputInventory.func_70301_a(0).equals(ItemStack.field_190927_a)) {
            return true;
        }
        ItemStack i = this.recipe.getOutput(this.conditionProvider);
        return InventoryUtils.canInsertAll((IInventory)this.outputInventory, (int)0, (ItemStack)i);
    }

    protected void onProcessTicks(int i) {
        if (this.recipe == null) {
            this.resetTracker();
        } else {
            this.energyStorage.extractEnergy(Energy.fromPotential(this.voltage, POTENTIAL_PER_TICK * (long)i), false);
        }
        this.func_70296_d();
    }

    protected void onCompleteProcess() {
        ItemStack[] is = this.recipe.getInputItems(this.conditionProvider);
        FluidStack fs = this.recipe.getInputFluid(this.conditionProvider);
        ItemStack os = this.recipe.getOutput(this.conditionProvider);
        InventoryUtils.extractItem((IInventory)this.inputInventory, (int)0, (int)is[0].func_190916_E(), (boolean)false);
        InventoryUtils.extractItem((IInventory)this.inputInventory, (int)1, (int)is[1].func_190916_E(), (boolean)false);
        InventoryUtils.extractItem((IInventory)this.inputInventory, (int)2, (int)is[2].func_190916_E(), (boolean)false);
        InventoryUtils.insertItem((IInventory)this.outputInventory, (int)0, (ItemStack)os, (boolean)false);
        this.fluidTank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
    }

    protected int getProcessDuration() {
        if (this.recipe != null) {
            return (int)(this.recipe.getRequiredEnergy(this.conditionProvider) / POTENTIAL_PER_TICK);
        }
        return 1000;
    }
}

