/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_assembler.obj;

import com.valkyrieofnight.envirocore.core.tile.machine.ECEnergyReceiverTile;
import com.valkyrieofnight.envirocore.m_comp.m_modifier.CModifiersModule;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.MAssembler;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.datapack.AssemblerRecipe;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.net.SetStackSizePacket;
import com.valkyrieofnight.envirocore.m_machines.m_assembler.ui.AssemblerContainer;
import com.valkyrieofnight.enviroenergyapi.api.VoltageRange;
import com.valkyrieofnight.vlib.core.obj.container.item.VLFixedStackSizeInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.network.BaseTilePacket;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.NoAccelerationModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.ItemModifierHandler;
import com.valkyrieofnight.vlib.modifier.inv.VLModifierInventory;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class AssemblerTile
extends ECEnergyReceiverTile
implements IProvideGui<AssemblerContainer> {
    protected static int POTENTIAL_PER_TICK = 1000;
    protected static int VOLTAGE = VoltageRange.EXTRA_LOW.getMaxVoltage();
    protected VLFixedStackSizeInventory input = new VLFixedStackSizeInventory(1, new IOMode[]{IOMode.IN, IOMode.IN, IOMode.IN, IOMode.IN, IOMode.IN});
    protected VLInventory output = new VLInventory(new IOMode[]{IOMode.OUT});
    protected VLModifierInventory modifiers = new VLModifierInventory(4);
    protected ItemModifierHandler modifierHandler;
    protected AssemblerRecipe recipe;
    protected ItemStack recipeOutput;
    protected TrackerModule tracker;

    public AssemblerContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        if (tileEntity instanceof AssemblerTile) {
            return new AssemblerContainer(i, playerEntity.field_71071_by, (AssemblerTile)tileEntity);
        }
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 0 || index > 4) {
            return false;
        }
        ItemStack[] input = new ItemStack[5];
        input[index] = stack;
        for (int i = 0; i < input.length; ++i) {
            if (index == i) continue;
            input[i] = this.input.func_70301_a(i).func_77946_l();
        }
        return MAssembler.REGISTRY.hasRecipeWithInput(null, this.conditionProvider, input);
    }

    public AssemblerTile() {
        super(MAssembler.TILE_TYPE, VOLTAGE, POTENTIAL_PER_TICK * 2000);
        this.input.setCanPlace(this::func_94041_b);
        this.setupInventory(new IVLSerializableInventory[]{this.input, this.output, this.modifiers});
        this.modifierHandler = new ItemModifierHandler(this.modifiers);
        this.modifierHandler.addScannable(CModifiersModule.FREQUENCY_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.ENERGY_MULTIPLIER_ATTRIBUTE.getID());
        this.setupMainModule(((NoAccelerationModule.Builder)ModuleBuilders.noAcceleration().addModule((IModuleBuilder)ModuleBuilders.serverTicker(() -> ((ItemModifierHandler)this.modifierHandler).scanAttributes()))).addModule((IModuleBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).canStartProcess(this::canStartProcess)).checkAndValidateProcessable(this::checkAndValidateProcessable)).canCompleteProcess(this::canCompleteProcess)).onProcessTick(this::onProcessTicks)).onComplete(this::onCompleteProcess)).maxTickRate(this::getMaxTickRate)).processDuration(this::getProcessDuration)));
    }

    protected void resetTracker() {
        this.tracker.reset();
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    public void receiveData(BaseTilePacket packet) {
        if (packet instanceof SetStackSizePacket) {
            SetStackSizePacket p = (SetStackSizePacket)packet;
            this.input.setMaxStackSize(p.getStackSize());
            this.func_70296_d();
        }
        super.receiveData(packet);
    }

    public int getStackSize() {
        return this.input.func_70297_j_();
    }

    protected boolean canStartProcess() {
        if (this.recipe == null || !this.isRecipeInputValid()) {
            this.recipe = MAssembler.REGISTRY.getRecipe(this.conditionProvider, this.input.func_70301_a(0), this.input.func_70301_a(1), this.input.func_70301_a(2), this.input.func_70301_a(3), this.input.func_70301_a(4));
            this.recipeOutput = this.getOutputFromRecipe();
        }
        if (this.recipe != null) {
            if (this.isRecipeInputValid() && InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)this.recipeOutput)) {
                return true;
            }
            this.recipe = null;
            this.recipeOutput = ItemStack.field_190927_a;
            return false;
        }
        return false;
    }

    private boolean isRecipeInputValid() {
        return this.recipe.testInputs(this.conditionProvider, this.input.func_70301_a(0), this.input.func_70301_a(1), this.input.func_70301_a(2), this.input.func_70301_a(3), this.input.func_70301_a(4));
    }

    protected int checkAndValidateProcessable(int i) {
        if (this.recipe == null || !this.isRecipeInputValid()) {
            this.recipe = null;
            this.recipeOutput = ItemStack.field_190927_a;
            this.resetTracker();
        }
        if (this.energyStorage.getPotentialStored() >= this.getPotentialTick(i)) {
            return i;
        }
        return 0;
    }

    protected long getPotentialTick(int i) {
        return CModifiersModule.FREQUENCY_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, POTENTIAL_PER_TICK * i).intValue();
    }

    protected void onProcessTicks(int i) {
        if (this.recipe == null) {
            this.resetTracker();
        } else {
            this.energyStorage.extractInternal(this.getPotentialTick(i), false);
        }
        this.func_70296_d();
    }

    protected boolean canCompleteProcess() {
        if (this.recipe == null || !this.isRecipeInputValid()) {
            this.resetTracker();
            return false;
        }
        if (this.output.func_70301_a(0).equals(ItemStack.field_190927_a)) {
            return true;
        }
        return InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)this.recipeOutput);
    }

    private ItemStack getOutputFromRecipe() {
        if (this.recipe == null) {
            this.resetTracker();
            return ItemStack.field_190927_a;
        }
        ItemStack in = this.input.func_70301_a(4).func_77946_l();
        CompoundNBT oldNBT = in.func_77942_o() ? in.func_77978_p() : new CompoundNBT();
        ItemStack out = this.recipe.getOutput(this.conditionProvider).func_77946_l();
        if (!oldNBT.isEmpty()) {
            out.func_77982_d(oldNBT.func_74737_b().func_197643_a(out.func_77978_p()));
        }
        return out;
    }

    protected void onCompleteProcess() {
        if (this.recipeOutput == ItemStack.field_190927_a) {
            this.recipeOutput = this.getOutputFromRecipe();
        }
        if (this.recipe.hasInput(0)) {
            InventoryUtils.extractItem((IInventory)this.input, (int)0, (int)this.recipe.getInputCount(this.conditionProvider, 0), (boolean)false);
        }
        if (this.recipe.hasInput(1)) {
            InventoryUtils.extractItem((IInventory)this.input, (int)1, (int)this.recipe.getInputCount(this.conditionProvider, 1), (boolean)false);
        }
        if (this.recipe.hasInput(2)) {
            InventoryUtils.extractItem((IInventory)this.input, (int)2, (int)this.recipe.getInputCount(this.conditionProvider, 2), (boolean)false);
        }
        if (this.recipe.hasInput(3)) {
            InventoryUtils.extractItem((IInventory)this.input, (int)3, (int)this.recipe.getInputCount(this.conditionProvider, 3), (boolean)false);
        }
        InventoryUtils.extractItem((IInventory)this.input, (int)4, (int)this.recipe.getInputCount(this.conditionProvider, 4), (boolean)false);
        InventoryUtils.insertItem((IInventory)this.output, (int)0, (ItemStack)this.recipeOutput.func_77946_l(), (boolean)false);
        if (this.isRecipeInputValid()) {
            this.recipeOutput = ItemStack.field_190927_a;
            this.recipe = null;
        }
    }

    protected int getMaxTickRate() {
        return 1;
    }

    protected int getProcessDuration() {
        int base = this.recipe != null ? this.recipe.getDuration(this.conditionProvider) : 200;
        return Math.max(1, CModifiersModule.FREQUENCY_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, base));
    }
}

