/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipe;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class AbstractCatListRecipeRegistry<RECIPE extends AbstractCatListRecipe>
extends VLRecipeRegistry<RECIPE> {
    protected List<RECIPE> all = Lists.newArrayList();
    protected Map<VLID, List<RECIPE>> catToRecipe = Maps.newHashMap();
    protected Map<VLID, RECIPE> idToRecipe = Maps.newHashMap();

    public AbstractCatListRecipeRegistry(String registryID, Class<RECIPE> recipeClass) {
        super("envirocore", registryID, recipeClass);
    }

    public AbstractCatListRecipeRegistry(String mod, String registryID, Class<RECIPE> recipeClass) {
        super(mod, registryID, recipeClass);
    }

    protected void clearForNewData() {
        this.catToRecipe = Maps.newHashMap();
        this.all = Lists.newArrayList();
        this.idToRecipe = Maps.newHashMap();
    }

    public Collection<RECIPE> getAllRecipes(VLID vlid) {
        return this.all;
    }

    public List<RECIPE> getAll() {
        return this.all;
    }

    public List<RECIPE> getRecipesWithInput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        ArrayList recipes = Lists.newArrayList();
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AbstractCatListRecipe r : this.getAllRecipes(vlid)) {
                if (!r.testInput(conditionContainerProvider, i)) continue;
                recipes.add(r);
            }
        }
        return recipes;
    }

    public List<RECIPE> getRecipesWithOutput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        ArrayList recipes = Lists.newArrayList();
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AbstractCatListRecipe r : this.getAllRecipes(vlid)) {
                if (!r.testOutput(conditionContainerProvider, i)) continue;
                recipes.add(r);
            }
        }
        return null;
    }

    public boolean hasRecipeWithInput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AbstractCatListRecipe r : this.getAllRecipes(vlid)) {
                if (!r.testInput(conditionContainerProvider, i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRecipeWithOutput(VLID vlid, ConditionContainerProvider conditionContainerProvider, Object o) {
        if (o instanceof ItemStack) {
            ItemStack i = (ItemStack)o;
            for (AbstractCatListRecipe r : this.getAllRecipes(vlid)) {
                if (!r.testOutput(conditionContainerProvider, i)) continue;
                return true;
            }
        }
        return false;
    }

    protected void loadDataIntoRegistry(Map<VLID, RECIPE> map) {
        this.idToRecipe = map;
        for (VLID rid : map.keySet()) {
            AbstractCatListRecipe lgr = (AbstractCatListRecipe)((Object)map.get(rid));
            for (VLID program : lgr.getCategories()) {
                this.catToRecipe.computeIfAbsent(program, v -> Lists.newArrayList());
                this.catToRecipe.computeIfPresent(program, (vlid, recipes) -> {
                    recipes.add(lgr);
                    return recipes;
                });
            }
            this.all.add((RECIPE)((Object)lgr));
        }
    }

    protected RECIPE mergeNoOverride(RECIPE recipe, RECIPE recipe_type1) {
        return recipe;
    }

    public RECIPE getRecipe(VLID recipeID) {
        if (recipeID == null) {
            return null;
        }
        return (RECIPE)((Object)((AbstractCatListRecipe)((Object)this.idToRecipe.get(recipeID))));
    }

    public List<RECIPE> getAllForCategory(VLID category) {
        if (category != null && this.catToRecipe.containsKey(category)) {
            return this.catToRecipe.get(category);
        }
        return null;
    }
}

