/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.tile.machine;

import com.valkyrieofnight.envirocore.core.energy.RFProviderWrapper;
import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.machine.ECFacingMachineTile;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.tile.IEEProvider;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class ECPotentialEnergyProviderTile
extends ECFacingMachineTile
implements IEEProvider {
    protected UniPotentialBattery energyStorage;
    protected RFProviderWrapper wrapper;
    private LazyOptional<RFProviderWrapper> rfOptional;

    public ECPotentialEnergyProviderTile(TileEntityType<?> blockEntityType_1, UniPotentialBattery potentialBattery) {
        super(blockEntityType_1);
        this.energyStorage = this.energyStorage;
        this.wrapper = new RFProviderWrapper(this.energyStorage);
        this.rfOptional = LazyOptional.of(() -> this.wrapper);
    }

    @Override
    public Energy extractEnergy(Direction direction, Energy energy, boolean sim) {
        if (!sim) {
            this.func_70296_d();
        }
        return this.energyStorage.extractEnergy(energy, sim);
    }

    @Override
    public boolean canConnect(Direction direction) {
        return true;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("energy")) {
            this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        }
        super.load(nbt, type);
    }

    public float getEnergyScaled() {
        return this.energyStorage.getPotentialScaled();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            this.rfOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

