/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.tile.machine;

import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.machine.ECFacingMachineTile;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.tile.IEEReceiver;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class ECEnergyReceiverTile
extends ECFacingMachineTile
implements IEEReceiver {
    protected int voltage;
    protected UniPotentialBattery energyStorage;
    private LazyOptional<UniPotentialBattery> rfOptional;

    public ECEnergyReceiverTile(TileEntityType<?> blockEntityType_1, int voltage, long potentialStorage) {
        super(blockEntityType_1);
        this.voltage = voltage;
        this.energyStorage = new UniPotentialBattery(potentialStorage, 0L, potentialStorage);
        this.energyStorage.setMarkDirtyAction(() -> ((ECEnergyReceiverTile)this).func_70296_d());
        this.rfOptional = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    public Energy receiveEnergy(Direction direction, Energy energy, boolean sim) {
        if (!sim) {
            this.func_70296_d();
        }
        return this.energyStorage.receiveEnergy(energy, sim);
    }

    @Override
    public Energy getMaxReceive(Direction direction) {
        return Energy.fromPotential(this.voltage, this.energyStorage.getMaxReceive());
    }

    @Override
    public int getReceiveVoltage(Direction direction) {
        return this.voltage;
    }

    @Override
    public int getCurrentStored(Direction direction) {
        return MathUtil.safeLongToInt((long)(this.energyStorage.getPotentialStored() / (long)this.voltage));
    }

    @Override
    public int getCurrentCapacity(Direction direction) {
        return MathUtil.safeLongToInt((long)(this.energyStorage.getPotentialCapacity() / (long)this.voltage));
    }

    @Override
    public boolean canConnect(Direction direction) {
        return true;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("energy")) {
            this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        }
        super.load(nbt, type);
    }

    public float getEnergyScaled() {
        return this.energyStorage.getPotentialScaled();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(cap, side);
    }

    public final int getFEStored() {
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.energyStorage.getPotentialStored());
    }

    public final int getFECapacity() {
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.energyStorage.getPotentialCapacity());
    }
}

