/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.tile.machine;

import com.valkyrieofnight.envirocore.core.energy.RFProviderWrapper;
import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.machine.ECFacingMachineTile;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.tile.IEEProvider;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class ECEnergyProviderTile
extends ECFacingMachineTile
implements IEEProvider {
    protected int voltage;
    protected UniPotentialBattery energyStorage;
    protected RFProviderWrapper wrapper;
    private LazyOptional<RFProviderWrapper> rfOptional;

    public ECEnergyProviderTile(TileEntityType<?> blockEntityType_1, UniPotentialBattery energyStorage, int voltage) {
        super(blockEntityType_1);
        this.voltage = voltage;
        this.energyStorage = energyStorage;
        this.wrapper = new RFProviderWrapper(this.energyStorage);
        this.rfOptional = LazyOptional.of(() -> this.wrapper);
    }

    @Override
    public Energy extractEnergy(Direction direction, Energy energy, boolean sim) {
        if (!sim) {
            this.func_70296_d();
        }
        return this.energyStorage.extractEnergy(energy, sim);
    }

    @Override
    public Energy getMaxExtract(Direction direction) {
        return Energy.fromPotential(this.voltage, this.energyStorage.getMaxExtract());
    }

    @Override
    public int getExtractVoltage(Direction direction) {
        return this.voltage;
    }

    @Override
    public int getCurrentStored(Direction direction) {
        return MathUtil.safeLongToInt((long)(this.energyStorage.getPotentialStored() / (long)this.voltage));
    }

    @Override
    public int getCurrentCapacity(Direction direction) {
        return MathUtil.safeLongToInt((long)(this.energyStorage.getPotentialCapacity() / (long)this.voltage));
    }

    @Override
    public boolean canConnect(Direction direction) {
        return true;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("energy")) {
            this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        }
        super.load(nbt, type);
    }

    public float getEnergyScaled() {
        return this.energyStorage.getPotentialScaled();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            this.rfOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

